/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.config.LoggingInitializer;
import org.jacorb.orb.ORB;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.NO_IMPLEMENT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacORBConfiguration
implements Configuration {
    private static final String fileSuffix = ".properties";
    private static final String COMMON_PROPS = "orb.properties";
    private static final String TRUE = "true";
    private static final String ON = "on";
    private static final String ATTR_LOGGING_INITIALIZER = "jacorb.log.initializer";
    public static final boolean useTCCL;
    private HashMap<String, String> stringAttributes = new HashMap();
    private HashMap<String, Boolean> booleanAttributes = new HashMap();
    private HashMap<String, Number> numberAttributes = new HashMap();
    private final ORB orb;
    private Logger logger;
    private LoggingInitializer li;

    public static Configuration getConfiguration(Properties props, org.omg.CORBA.ORB orb, boolean isApplet) throws ConfigurationException {
        if (!(orb instanceof ORB)) {
            throw new ConfigurationException("ORB must not be null and must be a JacORB ORB " + (orb == null ? "<null>" : orb.getClass().getName()));
        }
        return JacORBConfiguration.getConfiguration(props, (ORB)orb, null, isApplet);
    }

    public static Configuration getConfiguration(Properties props, ORB orb, String orbid, boolean isApplet) throws ConfigurationException {
        String orbID = "jacorb";
        String myOrbID = null;
        if (!isApplet) {
            try {
                myOrbID = System.getProperty("ORBid");
            }
            catch (SecurityException e) {
                isApplet = true;
                System.err.println("Could not access system property 'ORBid' - will use default...");
            }
        }
        if (orbid != null && orbid.length() > 0) {
            myOrbID = orbid;
        }
        if (myOrbID != null && !myOrbID.equals("")) {
            if (myOrbID.equals("orb") || myOrbID.equals("jacorb")) {
                throw new ConfigurationException("Illegal orbID, <" + myOrbID + "> is reserved");
            }
            orbID = myOrbID;
        }
        return new JacORBConfiguration(orbID, props, orb, isApplet);
    }

    private JacORBConfiguration(String name, Properties orbProperties, ORB orb, boolean isApplet) throws ConfigurationException {
        this.orb = orb;
        LinkedHashMap<Level, String> delayedLogging = new LinkedHashMap<Level, String>();
        if (isApplet) {
            this.initApplet(delayedLogging, name, orbProperties);
        } else {
            this.init(delayedLogging, name, orbProperties);
        }
        this.initLogging();
        this.logger = this.getLogger("org.jacorb.config");
        for (Map.Entry<Level, String> e : delayedLogging.entrySet()) {
            if (e.getKey() == Level.INFO) {
                this.logger.info(e.getValue());
                continue;
            }
            if (e.getKey() == Level.WARNING) {
                this.logger.warn(e.getValue());
                continue;
            }
            if (e.getKey() == Level.FINE) {
                this.logger.debug(e.getValue());
                continue;
            }
            throw new NO_IMPLEMENT("Only info/warn delayed logging implemented.");
        }
    }

    private void init(LinkedHashMap<Level, String> delayedLogging, String name, Properties orbProperties) throws ConfigurationException {
        List<String> customPropFileNames;
        Properties orbConfig;
        String configDir;
        String propFile;
        Properties commonProps;
        if (name == null) {
            throw new ConfigurationException("Illegal null value for ORB name!");
        }
        String separator = System.getProperty("file.separator");
        String home = System.getProperty("user.home");
        String lib = System.getProperty("java.home");
        boolean loaded = false;
        this.setAttributes(System.getProperties());
        if (orbProperties != null) {
            loaded = true;
            this.setAttributes(orbProperties);
        }
        if ((commonProps = this.loadPropertiesFromFile(propFile = lib + separator + "lib" + separator + COMMON_PROPS)) != null) {
            this.setAttributes(commonProps);
            loaded = true;
            delayedLogging.put(Level.FINE, "base configuration loaded from file " + propFile);
        }
        if ((commonProps = this.loadPropertiesFromFile(propFile = home + separator + COMMON_PROPS)) != null) {
            this.setAttributes(commonProps);
            loaded = true;
            delayedLogging.put(Level.FINE, "base configuration loaded from file " + propFile);
        }
        if ((commonProps = this.loadPropertiesFromClassPath(COMMON_PROPS)) != null) {
            loaded = true;
            this.setAttributes(commonProps);
            delayedLogging.put(Level.FINE, "base configuration loaded from classpath orb.properties");
        }
        if ((configDir = this.getAttribute("jacorb.config.dir", "")).length() == 0) {
            configDir = this.getAttribute("jacorb.home", "");
            if (configDir.length() != 0) {
                configDir = configDir + separator + "etc";
            } else {
                delayedLogging.put(Level.FINE, "jacorb.home unset! Will use '.'");
                configDir = ".";
            }
        }
        if ((orbConfig = this.loadPropertiesFromFile(propFile = configDir + separator + name + fileSuffix)) != null) {
            this.setAttributes(orbConfig);
            loaded = true;
            delayedLogging.put(Level.FINE, "configuration " + name + " loaded from file " + propFile + (this.orb == null ? " for ORBSingleton" : " for " + this.orb));
        }
        if ((orbConfig = this.loadPropertiesFromClassPath(name + fileSuffix)) != null) {
            this.setAttributes(orbConfig);
            loaded = true;
            delayedLogging.put(Level.FINE, "configuration " + name + " loaded from classpath" + (this.orb == null ? " for ORBSingleton" : " for " + this.orb));
        }
        if (!(customPropFileNames = this.getAttributeList("custom.props")).isEmpty()) {
            for (String fileName : customPropFileNames) {
                Properties customProps = this.loadPropertiesFromFile(fileName);
                if (customProps != null) {
                    this.setAttributes(customProps);
                    loaded = true;
                    delayedLogging.put(Level.FINE, "custom properties loaded from file " + fileName);
                    continue;
                }
                delayedLogging.put(Level.WARNING, "custom properties not found in " + fileName);
            }
        }
        this.setAttributes(System.getProperties());
        if (orbProperties != null) {
            loaded = true;
            this.setAttributes(orbProperties);
            if (orbProperties.containsKey("org.omg.CORBA.ORBClass") && System.getProperty("org.omg.CORBA.ORBClass") == null) {
                System.setProperty("org.omg.CORBA.ORBClass", orbProperties.getProperty("org.omg.CORBA.ORBClass"));
            }
            if (orbProperties.containsKey("org.omg.CORBA.ORBSingletonClass") && System.getProperty("org.omg.CORBA.ORBSingletonClass") == null) {
                System.setProperty("org.omg.CORBA.ORBSingletonClass", orbProperties.getProperty("org.omg.CORBA.ORBSingletonClass"));
            }
        }
        if (!loaded) {
            delayedLogging.put(Level.FINE, "no properties found for configuration " + name);
        }
    }

    private void initApplet(LinkedHashMap<Level, String> delayedLogging, String name, Properties orbProperties) throws ConfigurationException {
        String propFile;
        Properties orbConfig;
        Properties commonProps;
        if (name == null) {
            throw new ConfigurationException("Illegal null value for ORB name!");
        }
        boolean loaded = false;
        if (orbProperties != null) {
            this.setAttributes(orbProperties);
        }
        if ((commonProps = this.loadPropertiesFromClassPath(COMMON_PROPS)) != null) {
            this.setAttributes(commonProps);
            loaded = true;
            delayedLogging.put(Level.FINE, "base configuration loaded from classpath orb.properties");
        }
        if ((orbConfig = this.loadPropertiesFromClassPath(propFile = name + fileSuffix)) != null) {
            this.setAttributes(orbConfig);
            loaded = true;
            delayedLogging.put(Level.FINE, "configuration " + name + " loaded from classpath " + propFile);
        } else {
            delayedLogging.put(Level.WARNING, "File " + propFile + " for configuration " + name + " not found in classpath");
        }
        List<String> customPropFileNames = this.getAttributeList("custom.props");
        if (!customPropFileNames.isEmpty()) {
            for (String fileName : customPropFileNames) {
                Properties customProps = this.loadPropertiesFromClassPath(fileName);
                if (customProps != null) {
                    this.setAttributes(customProps);
                    loaded = true;
                    delayedLogging.put(Level.FINE, "custom properties loaded from classpath " + fileName);
                    continue;
                }
                delayedLogging.put(Level.WARNING, "custom properties " + fileName + " not found in classpath");
            }
        }
        if (orbProperties != null) {
            loaded = true;
            this.setAttributes(orbProperties);
        }
        if (!loaded) {
            delayedLogging.put(Level.WARNING, "no properties found for configuration " + name);
        }
    }

    @Override
    public void setAttribute(String key, String value) {
        this.stringAttributes.put(key, value);
    }

    @Override
    public void setAttribute(String key, int value) {
        this.numberAttributes.put(key, value);
    }

    @Override
    public void setAttributes(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            this.setAttribute(key, properties.getProperty(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFromFile(String fileName) {
        Properties properties;
        FileInputStream stream = new FileInputStream(fileName);
        try {
            Properties result = new Properties();
            result.load(stream);
            properties = result;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                System.err.println("could not read config file: " + fileName);
                e.printStackTrace();
                return null;
            }
        }
        ((InputStream)stream).close();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFromClassPath(String name) {
        Properties result;
        block6: {
            result = null;
            try {
                ClassLoader clazzLoader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : JacORBConfiguration.class.getClassLoader();
                URL url = clazzLoader.getResource(name);
                if (url == null) break block6;
                result = new Properties();
                InputStream stream = url.openStream();
                try {
                    result.load(stream);
                }
                finally {
                    stream.close();
                }
            }
            catch (FileNotFoundException ex) {
            }
            catch (IOException ioe) {
                System.err.println("could not read config file: " + name);
                ioe.printStackTrace();
            }
        }
        return result;
    }

    private void initLogging() throws ConfigurationException {
        this.li = (LoggingInitializer)this.getAttributeAsObject(ATTR_LOGGING_INITIALIZER, "org.jacorb.config.JdkLoggingInitializer");
        this.li.init(this);
    }

    public void shutdownLogging() {
        this.li.shutdownLogging();
    }

    @Override
    public ORB getORB() {
        return this.orb;
    }

    @Override
    public Logger getLogger(String name) {
        String implName;
        String loggerName = name;
        if (this.getAttributeAsBoolean("jacorb.log.split_on_implname", false) && (implName = this.getAttribute("jacorb.implname", null)) != null && implName.length() > 0) {
            if (name.equals("jacorb")) {
                loggerName = "org.jacorb." + implName;
            } else if (name.startsWith("org.jacorb.")) {
                loggerName = "org.jacorb." + implName + "." + name.substring(11);
            }
        }
        return LoggerFactory.getLogger((String)loggerName);
    }

    @Override
    public String getAttribute(String key) throws ConfigurationException {
        String result = this.getAttribute(key, null);
        if (result == null) {
            throw new ConfigurationException("attribute " + key + " is not defined");
        }
        return result;
    }

    @Override
    public String getAttribute(String key, String defaultValue) {
        String result = this.stringAttributes.get(key);
        if (result == null && defaultValue != null) {
            this.stringAttributes.put(key, defaultValue);
            result = defaultValue;
        } else if (result != null) {
            result = result.trim();
        }
        return result;
    }

    @Override
    public int getAttributeAsInteger(String key, int defaultValue) throws ConfigurationException {
        return this.getAttributeAsInteger(key, defaultValue, 10);
    }

    @Override
    public int getAttributeAsInteger(String key, int defaultValue, int radix) throws ConfigurationException {
        Number result = this.numberAttributes.get(key);
        if (result == null) {
            String value = this.stringAttributes.get(key);
            if (value == null) {
                result = defaultValue;
            } else if (value.trim().length() < 1) {
                result = defaultValue;
            } else {
                try {
                    result = Integer.parseInt(value.trim(), radix);
                }
                catch (NumberFormatException ex) {
                    throw new ConfigurationException("value for attribute " + key + " is not numeric: " + value);
                }
            }
            this.numberAttributes.put(key, result);
        }
        return result.intValue();
    }

    @Override
    public int getAttributeAsInteger(String key) throws ConfigurationException {
        if (!this.stringAttributes.containsKey(key) && !this.numberAttributes.containsKey(key)) {
            throw new ConfigurationException("Value for attribute " + key + " is not set");
        }
        return this.getAttributeAsInteger(key, -1, 10);
    }

    @Override
    public long getAttributeAsLong(String key, long defaultValue) throws ConfigurationException {
        Number result = this.numberAttributes.get(key);
        if (result == null) {
            String value = this.stringAttributes.get(key);
            if (value == null) {
                result = defaultValue;
            } else if (value.trim().length() < 1) {
                result = defaultValue;
            } else {
                try {
                    result = Long.parseLong(value.trim());
                }
                catch (NumberFormatException ex) {
                    throw new ConfigurationException("value for attribute " + key + " is not numeric: " + value);
                }
            }
            this.numberAttributes.put(key, result);
        }
        return result.longValue();
    }

    @Override
    public List<String> getAttributeList(String key) {
        ArrayList<String> result = new ArrayList<String>();
        String value = null;
        try {
            value = this.getAttribute(key);
        }
        catch (ConfigurationException ce) {
            // empty catch block
        }
        if (value != null) {
            StringTokenizer tok = new StringTokenizer(value, ",");
            while (tok.hasMoreTokens()) {
                result.add(tok.nextToken().trim());
            }
        }
        return result;
    }

    @Override
    public String[] getAttributeAsStringsArray(String key) {
        String value = null;
        try {
            value = this.getAttribute(key);
        }
        catch (ConfigurationException ce) {
            // empty catch block
        }
        if (value == null) {
            return null;
        }
        List<String> values = this.getAttributeList(key);
        if (values.size() < 1) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    private Object newInstance(String key, String className) throws ConfigurationException {
        try {
            Class<?> clazz = ObjectUtil.classForName(className);
            Object instance = clazz.newInstance();
            if (instance instanceof Configurable) {
                ((Configurable)instance).configure(this);
            }
            return instance;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to build class from key >" + key + "<: " + e);
        }
    }

    @Override
    public Object getAttributeAsObject(String key) throws ConfigurationException {
        return this.getAttributeAsObject(key, "");
    }

    @Override
    public Object getAttributeAsObject(String key, String defaultClass) throws ConfigurationException {
        Object result = null;
        String classname = this.getAttribute(key, "");
        if (classname.length() > 0) {
            result = this.newInstance(key, classname);
        } else if (defaultClass != null && defaultClass.length() > 0) {
            result = this.newInstance("default", defaultClass);
        }
        return result;
    }

    @Override
    public boolean getAttributeAsBoolean(String key, boolean defaultValue) {
        Boolean result = this.booleanAttributes.get(key);
        if (result == null) {
            String value = this.stringAttributes.get(key);
            result = value == null ? Boolean.valueOf(defaultValue) : (value.trim().length() < 1 ? Boolean.valueOf(defaultValue) : Boolean.valueOf(ON.equals(value = value.trim().toLowerCase()) || TRUE.equals(value)));
            this.booleanAttributes.put(key, result);
        }
        return result;
    }

    private String[] getAttributeNames() {
        return this.stringAttributes.keySet().toArray(new String[0]);
    }

    @Override
    public List<String> getAttributeNamesWithPrefix(String prefix) {
        ArrayList<String> attributesWithPrefix = new ArrayList<String>();
        String[] allAttributes = this.getAttributeNames();
        for (int x = 0; x < allAttributes.length; ++x) {
            if (!allAttributes[x].startsWith(prefix)) continue;
            attributesWithPrefix.add(allAttributes[x]);
        }
        return Collections.unmodifiableList(attributesWithPrefix);
    }

    @Override
    public double getAttributeAsFloat(String key, double defaultValue) throws ConfigurationException {
        Number result = this.numberAttributes.get(key);
        if (result == null) {
            String value = this.stringAttributes.get(key);
            if (value == null) {
                result = defaultValue;
            } else if (value.trim().length() < 1) {
                result = defaultValue;
            } else {
                try {
                    result = Double.parseDouble(value.trim());
                }
                catch (NumberFormatException ex) {
                    throw new ConfigurationException("value for attribute " + key + " is not numeric: " + value);
                }
            }
            this.numberAttributes.put(key, result);
        }
        return result.doubleValue();
    }

    static {
        String clpolicy = System.getProperty("jacorb.classloaderpolicy", "tccl");
        useTCCL = !clpolicy.equalsIgnoreCase("forname");
    }
}

