/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.applet.Applet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.config.JacORBConfiguration;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.DataInputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ImRAccess;
import org.jacorb.orb.NVList;
import org.jacorb.orb.NamedValue;
import org.jacorb.orb.ORBSingleton;
import org.jacorb.orb.ObjectKeyMap;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.RTORB;
import org.jacorb.orb.ServantDelegate;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.dii.ContextListImpl;
import org.jacorb.orb.dii.ExceptionList;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.dynany.DynAnyFactoryImpl;
import org.jacorb.orb.etf.FactoriesBase;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.miop.MIOPProfile;
import org.jacorb.orb.policies.ClientProtocolPolicy;
import org.jacorb.orb.policies.MaxHopsPolicy;
import org.jacorb.orb.policies.PolicyManager;
import org.jacorb.orb.policies.QueueOrderPolicy;
import org.jacorb.orb.policies.RebindPolicy;
import org.jacorb.orb.policies.RelativeRequestTimeoutPolicy;
import org.jacorb.orb.policies.RelativeRoundtripTimeoutPolicy;
import org.jacorb.orb.policies.ReplyEndTimePolicy;
import org.jacorb.orb.policies.ReplyPriorityPolicy;
import org.jacorb.orb.policies.ReplyStartTimePolicy;
import org.jacorb.orb.policies.RequestEndTimePolicy;
import org.jacorb.orb.policies.RequestPriorityPolicy;
import org.jacorb.orb.policies.RequestStartTimePolicy;
import org.jacorb.orb.policies.RoutingPolicy;
import org.jacorb.orb.policies.SyncScopePolicy;
import org.jacorb.orb.portableInterceptor.CodecFactoryImpl;
import org.jacorb.orb.portableInterceptor.IORInfoImpl;
import org.jacorb.orb.portableInterceptor.InterceptorManager;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.standardInterceptors.IORInterceptorInitializer;
import org.jacorb.orb.typecode.NullTypeCodeCache;
import org.jacorb.orb.typecode.NullTypeCodeCompactor;
import org.jacorb.orb.typecode.TypeCodeCache;
import org.jacorb.orb.typecode.TypeCodeCompactor;
import org.jacorb.poa.Current;
import org.jacorb.poa.POAListener;
import org.jacorb.poa.RPPoolManager;
import org.jacorb.poa.RPPoolManagerFactory;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.tao_imr.ImRAccessImpl;
import org.jacorb.util.ObjectUtil;
import org.jacorb.util.SelectorManager;
import org.jacorb.util.TimerQueue;
import org.jacorb.util.Version;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.Environment;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDef;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.ServiceInformationHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.ETF.Factories;
import org.omg.ETF.Profile;
import org.omg.IOP.IOR;
import org.omg.IOP.MultipleComponentProfileHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.Servant;
import org.slf4j.Logger;

public final class ORB
extends ORBSingleton
implements POAListener,
Configurable {
    private static final String nullIORString = "IOR:00000000000000010000000000000000";
    private static final String[] services = new String[]{"RootPOA", "POACurrent", "DynAnyFactory", "PICurrent", "CodecFactory", "RTORB"};
    private boolean cacheReferences;
    private String implName;
    private int giopMinorVersion;
    private boolean giopAdd_1_0_Profiles;
    private String hashTableClassName;
    private boolean useIMR = false;
    private boolean useTaoIMR = false;
    private boolean useSelectorManager;
    private ProtocolAddressBase imrProxyAddress = null;
    private ProtocolAddressBase iorProxyAddress;
    private final Map<String, Object> initial_references = new HashMap<String, Object>();
    private org.jacorb.poa.POA rootpoa;
    private Current poaCurrent;
    private BasicAdapter basicAdapter;
    private InterceptorManager interceptor_manager = null;
    private boolean hasClientInterceptors = false;
    private boolean hasServerInterceptors = false;
    private final org.omg.PortableInterceptor.Current piCurrent = new PICurrent();
    private Map<String, ObjectImpl> knownReferences = null;
    private ClientConnectionManager clientConnectionManager;
    private TransportManager transport_manager = null;
    private GIOPConnectionManager giop_connection_manager = null;
    private TimerQueue timer_queue = null;
    private SelectorManager selectorManager = null;
    private final Map<String, ValueFactory> valueFactories = new HashMap<String, ValueFactory>();
    private final Map<String, BoxedValueHelper> boxedValueHelpers = new HashMap<String, BoxedValueHelper>();
    private final ObjectKeyMap objectKeyMap = new ObjectKeyMap(this);
    private String[] arguments;
    private final java.lang.Object runSync = new java.lang.Object();
    private boolean run = true;
    private boolean shutdown_in_progress = false;
    private boolean destroyed = false;
    private final java.lang.Object shutdown_synch = new java.lang.Object();
    private ImRAccess imr = null;
    private int persistentPOACount;
    private String orb_id = "jacorb";
    private final Set<org.omg.CORBA.Request> requests = Collections.synchronizedSet(new HashSet());
    private Request request = null;
    private RTORB rtORB;
    private PolicyManager policyManager;
    private final Map<Integer, PolicyFactory> policy_factories = Collections.synchronizedMap(new HashMap());
    private boolean bidir_giop = false;
    private final String serverIdStr = String.valueOf((long)(Math.random() * 9.999999999E9));
    private final byte[] serverId = this.serverIdStr.getBytes();
    private RPPoolManagerFactory poolManagerFactory;
    private boolean failOnORBInitializerError;
    private boolean inORBInitializer;
    private String defaultInitRef;
    private boolean firstConnection = true;
    private Map connectedObjects = new HashMap();

    public ORB() {
        super(false);
    }

    @Override
    public void configure(Configuration config) throws ConfigurationException {
        boolean compactTypeCodes;
        super.configure(config);
        this.cacheReferences = this.configuration.getAttributeAsBoolean("jacorb.reference_caching", false);
        this.implName = this.configuration.getAttribute("jacorb.implname", "");
        this.giopMinorVersion = this.configuration.getAttributeAsInteger("jacorb.giop_minor_version", 2);
        this.giopAdd_1_0_Profiles = this.configuration.getAttributeAsBoolean("jacorb.giop.add_1_0_profiles", false);
        this.hashTableClassName = this.configuration.getAttribute("jacorb.hashtable_class", HashMap.class.getName());
        this.useIMR = this.configuration.getAttributeAsBoolean("jacorb.use_imr", false);
        this.useTaoIMR = this.configuration.getAttributeAsBoolean("jacorb.use_tao_imr", false);
        if (this.useTaoIMR && this.useIMR) {
            throw new ConfigurationException("Ambiguous ImR property settings: jacorb.use_tao_imr and jacorb.use_imr are both true");
        }
        String host = this.configuration.getAttribute("jacorb.imr.ior_proxy_host", null);
        int port = this.configuration.getAttributeAsInteger("jacorb.imr.ior_proxy_port", -1);
        String address = this.configuration.getAttribute("jacorb.imr.ior_proxy_address", null);
        this.imrProxyAddress = this.createAddress(host, port, address);
        if (this.useTaoIMR && this.imrProxyAddress != null) {
            this.imrProxyAddress = null;
        }
        host = this.configuration.getAttribute("jacorb.ior_proxy_host", null);
        port = this.configuration.getAttributeAsInteger("jacorb.ior_proxy_port", -1);
        address = this.configuration.getAttribute("jacorb.ior_proxy_address", null);
        this.iorProxyAddress = this.createAddress(host, port, address);
        if (this.useTaoIMR && this.iorProxyAddress != null) {
            this.iorProxyAddress = null;
        }
        this.failOnORBInitializerError = this.configuration.getAttributeAsBoolean("jacorb.orb_initializer.fail_on_error", false);
        boolean useTimerQueue = this.configuration.getAttributeAsBoolean("jacorb.use_timer_queue", false);
        if (!useTimerQueue) {
            useTimerQueue = this.configuration.getAttributeAsInteger("jacorb.connection.request.write_timeout", 0) > 0 || this.configuration.getAttributeAsInteger("jacorb.connection.reply.write_timeout", 0) > 0;
        }
        this.useSelectorManager = useTimerQueue || this.configuration.getAttributeAsBoolean("jacorb.connection.nonblocking", false);
        boolean cacheTypeCodes = this.configuration.getAttributeAsBoolean("jacorb.cacheTypecodes", false);
        if (cacheTypeCodes) {
            this.typeCodeCache = (TypeCodeCache)this.configuration.getAttributeAsObject("jacorb.cacheTypecodes.class", "org.jacorb.orb.typecode.TypeCodeCacheImpl");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("enabled TypeCodeCache: " + this.typeCodeCache.getClass().getName());
            }
        } else {
            this.typeCodeCache = NullTypeCodeCache.getInstance();
        }
        if (compactTypeCodes = this.configuration.getAttributeAsBoolean("jacorb.compactTypecodes", false)) {
            this.typeCodeCompactor = (TypeCodeCompactor)this.configuration.getAttributeAsObject("jacorb.compactTypecodes.class", "org.jacorb.orb.typecode.TypeCodeCompactorImpl");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("enabled TypeCodeCompactor: " + this.typeCodeCompactor.getClass().getName());
            }
        } else {
            this.typeCodeCompactor = NullTypeCodeCompactor.getInstance();
        }
        this.printVersion(this.configuration);
        this.configureObjectKeyMap(this.configuration);
        if (this.poolManagerFactory != null) {
            // empty if block
        }
        this.poolManagerFactory = new RPPoolManagerFactory(this);
    }

    private ProtocolAddressBase createAddress(String host, int port, String addressString) {
        ProtocolAddressBase address;
        try {
            if (addressString == null) {
                if (host != null || port != -1) {
                    address = new IIOPAddress();
                    address.configure(this.configuration);
                    if (host != null) {
                        ((IIOPAddress)address).setHostname(host);
                    }
                    if (port != -1) {
                        ((IIOPAddress)address).setPort(port);
                    }
                } else {
                    address = null;
                }
            } else {
                address = this.createAddress(addressString);
            }
        }
        catch (Exception ex) {
            this.logger.error("error initializing ProxyAddress", (Throwable)ex);
            throw new INITIALIZE(ex.toString());
        }
        return address;
    }

    private void printVersion(Configuration configuration) {
        boolean printVersion = configuration.getAttributeAsBoolean("jacorb.orb.print_version", false);
        if (!printVersion) {
            return;
        }
        Logger versionLogger = configuration.getLogger("org.jacorb.orb.print_version");
        versionLogger.info(System.getProperty("line.separator") + "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" + System.getProperty("line.separator") + Version.versionInfo + System.getProperty("line.separator") + "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
    }

    public String id() {
        return this.orb_id;
    }

    public boolean useBiDirGIOP() {
        return this.bidir_giop;
    }

    public void turnOnBiDirGIOP() {
        if (!this.bidir_giop) {
            this.bidir_giop = true;
            this.clientConnectionManager.setRequestListener(this.basicAdapter.getRequestListener());
        }
    }

    public ProtocolAddressBase createAddress(String address) {
        List<Factories> factorylist = this.getTransportManager().getFactoriesList();
        ProtocolAddressBase result = null;
        Iterator<Factories> i = factorylist.iterator();
        while (i.hasNext() && result == null) {
            FactoriesBase f = (FactoriesBase)i.next();
            result = f.create_protocol_address(address);
        }
        return result;
    }

    public Object _getObject(IOR ior) {
        Delegate delegate = new Delegate(this, ior, true);
        return delegate.getReference(null);
    }

    public synchronized Object _getDelegate(ParsedIOR pior) {
        ObjectImpl object;
        String key = pior.getIORString();
        if (this.cacheReferences && (object = this.knownReferences.get(key)) != null) {
            Delegate del = (Delegate)object._get_delegate();
            if (del != null) {
                ParsedIOR delpior = del.getParsedIOR();
                if (delpior == null) {
                    this.knownReferences.remove(key);
                    this.logger.debug("Removing an invalid reference from cache.");
                } else if (pior.getEffectiveProfile().is_match(delpior.getEffectiveProfile())) {
                    return object._duplicate();
                }
            } else {
                this.logger.debug("Remove stale reference from cache ");
                this.knownReferences.remove(key);
            }
        }
        Delegate delegate = new Delegate(this, pior);
        object = delegate.getReference(null);
        if (this.cacheReferences) {
            this.knownReferences.put(key, object);
        }
        return object;
    }

    org.jacorb.poa.POA findPOA(Delegate delegate, Object reference) {
        if (this.rootpoa == null || this.basicAdapter == null) {
            return null;
        }
        String refImplName = null;
        byte[] delegateObjectKey = delegate.getObjectKey();
        try {
            refImplName = POAUtil.extractImplName(delegateObjectKey);
        }
        catch (POAInternalError e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: reference generated by foreign POA", (Throwable)e);
            }
            return null;
        }
        if (refImplName == null) {
            if (this.implName.length() > 0 || this.serverIdStr.length() > 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("findPOA: impl_name mismatch - null != " + this.implName);
                }
                return null;
            }
        } else if (!this.implName.equals(refImplName) && !this.serverIdStr.equals(refImplName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: impl_name mismatch - " + refImplName + " != " + this.implName);
            }
            return null;
        }
        try {
            String res;
            org.jacorb.poa.POA tmp_poa = this.rootpoa;
            String poa_name = POAUtil.extractPOAName(delegateObjectKey);
            List<String> scopes = POAUtil.extractScopedPOANames(poa_name);
            for (int i = 0; i < scopes.size() && !"".equals(res = scopes.get(i)); ++i) {
                try {
                    tmp_poa = tmp_poa._getChildPOA(res);
                    continue;
                }
                catch (ParentIsHolding p) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("findPOA: holding adapter");
                    }
                    return null;
                }
            }
            byte[] objectId = POAUtil.extractOID(reference);
            if (tmp_poa.isSystemId() && !tmp_poa.previouslyGeneratedObjectId(objectId)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("findPOA: not a previously generated object key.");
                }
                return null;
            }
            return tmp_poa;
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(e.getMessage());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: nothing found");
            }
            return null;
        }
    }

    public ClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    synchronized void _release(String iorString) {
        if (this.cacheReferences) {
            this.knownReferences.remove(iorString);
        }
    }

    public Policy create_policy(int type, Any value) throws PolicyError {
        switch (type) {
            case 34: {
                return new MaxHopsPolicy(value);
            }
            case 35: {
                return new QueueOrderPolicy(value);
            }
            case 23: {
                return new RebindPolicy(value);
            }
            case 31: {
                return new RelativeRequestTimeoutPolicy(value);
            }
            case 32: {
                return new RelativeRoundtripTimeoutPolicy(value);
            }
            case 30: {
                return new ReplyEndTimePolicy(value);
            }
            case 26: {
                return new ReplyPriorityPolicy(value);
            }
            case 29: {
                return new ReplyStartTimePolicy(value);
            }
            case 28: {
                return new RequestEndTimePolicy(value);
            }
            case 25: {
                return new RequestPriorityPolicy(value);
            }
            case 27: {
                return new RequestStartTimePolicy(value);
            }
            case 33: {
                return new RoutingPolicy(value);
            }
            case 24: {
                return new SyncScopePolicy(value);
            }
            case 43: {
                return new ClientProtocolPolicy(value);
            }
        }
        PolicyFactory factory = this.policy_factories.get(type);
        if (factory == null) {
            throw new PolicyError();
        }
        return factory.create_policy(type, value);
    }

    public boolean hasPolicyFactoryForType(int type) {
        return this.policy_factories.containsKey(type);
    }

    @Override
    public ContextList create_context_list() {
        this.work_pending();
        return new ContextListImpl();
    }

    @Override
    public Environment create_environment() {
        this.work_pending();
        throw new NO_IMPLEMENT();
    }

    @Override
    public OutputStream create_output_stream() {
        this.work_pending();
        return new CDROutputStream((org.omg.CORBA.ORB)this);
    }

    IOR createIOR(String repId, byte[] objectKey, boolean _transient, org.jacorb.poa.POA poa, Map policy_overrides) {
        TaggedComponentList components;
        IIOPProfile iiopProfile;
        TaggedComponentList multipleComponents;
        HashMap<Integer, TaggedComponentList> componentMap;
        ArrayList<Profile> profiles;
        block10: {
            profiles = new ArrayList<Profile>();
            componentMap = new HashMap<Integer, TaggedComponentList>();
            int[] profileTags = new int[this.basicAdapter.getEndpointProfiles().size()];
            int n = 0;
            for (Profile profile : this.basicAdapter.getEndpointProfiles()) {
                if (profile instanceof MIOPProfile) continue;
                profile.set_object_key(objectKey);
                profiles.add(profile);
                profileTags[n++] = profile.tag();
                TaggedComponentList profileComponents = new TaggedComponentList();
                profileComponents.addComponent(this.create_ORB_TYPE_ID());
                componentMap.put(profile.tag(), profileComponents);
                if (!(profile instanceof ProfileBase)) continue;
                this.patchAddress((ProfileBase)profile, repId, _transient);
                if (!poa.isSSLRequired()) continue;
                ((ProfileBase)profile).patchPrimaryAddress(new IIOPAddress(null, 0));
            }
            multipleComponents = new TaggedComponentList();
            componentMap.put(1, multipleComponents);
            if (this.interceptor_manager != null && this.interceptor_manager.hasIORInterceptors()) {
                IORInfoImpl info = new IORInfoImpl(this, poa, componentMap, policy_overrides, profiles);
                try {
                    this.interceptor_manager.getIORIterator().iterate(info);
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block10;
                    this.logger.error(e.getMessage());
                }
            }
        }
        if ((iiopProfile = this.findIIOPProfile(profiles)) != null && (this.giopMinorVersion == 0 || this.giopAdd_1_0_Profiles)) {
            IIOPProfile profile_1_0 = iiopProfile.to_GIOP_1_0();
            profiles.add((Profile)profile_1_0);
            TaggedComponentList iiopComponents = (TaggedComponentList)componentMap.get(0);
            multipleComponents.addAll(iiopProfile.getComponents());
            multipleComponents.addAll(iiopComponents);
            if (this.giopMinorVersion == 0) {
                profiles.remove(iiopProfile);
            }
        }
        if (iiopProfile != null && this.isSSLRequiredInComponentList(components = (TaggedComponentList)componentMap.get(0))) {
            iiopProfile.patchPrimaryAddress(new IIOPAddress(null, 0));
        }
        TaggedProfile[] tps = null;
        if (multipleComponents.isEmpty()) {
            tps = new TaggedProfile[profiles.size()];
        } else {
            tps = new TaggedProfile[profiles.size() + 1];
            tps[tps.length - 1] = this.createMultipleComponentsProfile(multipleComponents);
        }
        TaggedComponentSeqHolder tc = new TaggedComponentSeqHolder();
        TaggedProfileHolder tp = new TaggedProfileHolder();
        for (int i = 0; i < profiles.size(); ++i) {
            Profile p = (Profile)profiles.get(i);
            TaggedComponentList clist = (TaggedComponentList)componentMap.get(p.tag());
            TaggedComponentList c = p instanceof ProfileBase ? this.patchTagAlternateIIOPAddresses((ProfileBase)p, clist, repId, _transient) : clist;
            tc.value = c.asArray();
            p.marshal(tp, tc);
            tps[i] = tp.value;
        }
        return new IOR(repId, tps);
    }

    private TaggedComponentList patchTagAlternateIIOPAddresses(ProfileBase profile, TaggedComponentList taggedCompList, String repId, boolean _transient) {
        if ("IDL:org/jacorb/imr/ImplementationRepository:1.0".equals(repId)) {
            return taggedCompList;
        }
        if (_transient || !this.useIMR && !this.useTaoIMR) {
            return taggedCompList;
        }
        profile.removeComponents(3);
        taggedCompList.removeComponents(3);
        TaggedComponentList list = new TaggedComponentList();
        list.addAll(taggedCompList);
        if (this.useTaoIMR) {
            this.getImR();
            if (this.imr != null) {
                List<Profile> plist = this.imr.getImRProfiles();
                int cnt = 0;
                for (IIOPProfile iIOPProfile : plist) {
                    List<IIOPAddress> addrList;
                    if (cnt++ != 0) {
                        try {
                            IIOPAddress address = new IIOPAddress(((IIOPAddress)iIOPProfile.getAddress()).getOriginalHost(), ((IIOPAddress)iIOPProfile.getAddress()).getPort());
                            address.configure(this.configuration);
                            list.addComponent(3, address.toCDR());
                        }
                        catch (ConfigurationException e) {
                            this.logger.warn("patchTagAlternateIIOPAddresses: got an exception, " + e.getMessage());
                        }
                    }
                    if ((addrList = iIOPProfile.getAlternateAddresses()) == null) continue;
                    for (IIOPAddress imrAddr : addrList) {
                        if (imrAddr == null) continue;
                        try {
                            IIOPAddress address = new IIOPAddress(imrAddr.getOriginalHost(), imrAddr.getPort());
                            address.configure(this.configuration);
                            list.addComponent(3, address.toCDR());
                        }
                        catch (ConfigurationException e) {
                            this.logger.warn("patchTagAlternateIIOPAddresses: got an exception, " + e.getMessage());
                        }
                    }
                }
            }
        }
        return list;
    }

    public boolean isSSLRequiredInComponentList(TaggedComponentList components) {
        int minimum_options = 30;
        if (components == null) {
            return false;
        }
        CompoundSecMechList csmList = (CompoundSecMechList)components.getComponent(33, CompoundSecMechListHelper.class);
        if (csmList != null && csmList.mechanism_list.length > 0 && csmList.mechanism_list[0].transport_mech.tag == 36) {
            byte[] tlsSecTransData = csmList.mechanism_list[0].transport_mech.component_data;
            CDRInputStream in = new CDRInputStream((org.omg.CORBA.ORB)this, tlsSecTransData);
            try {
                in.openEncapsulatedArray();
                TLS_SEC_TRANS tls = TLS_SEC_TRANSHelper.read((org.omg.CORBA.portable.InputStream)in);
                return (tls.target_requires & minimum_options) != 0;
            }
            catch (Exception ex) {
                throw new INTERNAL(ex.toString());
            }
        }
        return false;
    }

    private TaggedProfile createMultipleComponentsProfile(TaggedComponentList components) {
        CDROutputStream out = new CDROutputStream((org.omg.CORBA.ORB)this);
        out.beginEncapsulatedArray();
        MultipleComponentProfileHelper.write((OutputStream)out, (TaggedComponent[])components.asArray());
        return new TaggedProfile(1, out.getBufferCopy());
    }

    private IIOPProfile findIIOPProfile(List profiles) {
        for (Profile p : profiles) {
            if (!(p instanceof IIOPProfile)) continue;
            return (IIOPProfile)p;
        }
        return null;
    }

    @Override
    public Context get_default_context() {
        this.work_pending();
        throw new NO_IMPLEMENT();
    }

    public BasicAdapter getBasicAdapter() {
        if (this.basicAdapter == null) {
            throw new INITIALIZE("Adapters not initialized; resolve RootPOA.");
        }
        return this.basicAdapter;
    }

    public synchronized Current getPOACurrent() {
        if (this.poaCurrent == null) {
            this.poaCurrent = new Current();
        }
        return this.poaCurrent;
    }

    public Object getReference(org.jacorb.poa.POA poa, byte[] object_key, String rep_id, boolean _transient) {
        IOR ior = this.createIOR(rep_id == null ? "IDL:omg.org/CORBA/Object:1.0" : rep_id, object_key, _transient, poa, null);
        if (ior == null && this.logger.isErrorEnabled()) {
            this.logger.error("Interal error: createIOR returns null");
        }
        Delegate d = new Delegate(this, ior);
        return d.getReference(poa);
    }

    public synchronized org.jacorb.poa.POA getRootPOA() throws INITIALIZE {
        if (this.rootpoa == null) {
            org.jacorb.poa.POA tmppoa = org.jacorb.poa.POA._POA_init(this);
            tmppoa = org.jacorb.poa.POA._POA_init(this);
            this.basicAdapter = new BasicAdapter(this, tmppoa, this.getTransportManager(), this.giop_connection_manager);
            try {
                tmppoa.configure(this.configuration);
                this.basicAdapter.configure(this.configuration);
            }
            catch (ConfigurationException ce) {
                throw new INITIALIZE("ConfigurationException: " + ce.toString());
            }
            this.rootpoa = tmppoa;
            this.rootpoa._addPOAEventListener(this);
        }
        return this.rootpoa;
    }

    @Override
    public String[] list_initial_services() {
        this.work_pending();
        ArrayList<String> list = new ArrayList<String>(this.initial_references.size() + services.length);
        for (String i : services) {
            list.add(i);
        }
        list.addAll(this.initial_references.keySet());
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void poaCreated(org.jacorb.poa.POA poa) {
        poa._addPOAEventListener(this);
        if (poa.isPersistent()) {
            ++this.persistentPOACount;
            if (this.useIMR) {
                this.getImR();
                if (this.imr != null) {
                    String server_name = this.implName;
                    ProtocolAddressBase sep = this.getServerAddress();
                    if (sep instanceof IIOPAddress) {
                        String sep_host = ((IIOPAddress)sep).getHostname();
                        int sep_port = ((IIOPAddress)sep).getPort();
                        this.imr.registerPOA(server_name + "/" + poa._getQualifiedName(), server_name, sep_host, sep_port);
                    }
                }
            } else if (this.useTaoIMR) {
                ProtocolAddressBase sep;
                this.getImR();
                if (this.imr != null && (sep = this.getServerAddress()) instanceof IIOPAddress) {
                    this.imr.registerPOA(this, poa, sep, this.implName);
                }
            }
        }
    }

    private synchronized void getImR() {
        if (this.imr == null && (this.useIMR || this.useTaoIMR)) {
            try {
                if (this.useIMR) {
                    this.imr = org.jacorb.imr.ImRAccessImpl.connect((org.omg.CORBA.ORB)this);
                } else if (this.useTaoIMR) {
                    this.imr = ImRAccessImpl.connect(this);
                }
            }
            catch (Exception e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Error: No connection to ImplementationRepository");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(e.getMessage());
                }
                if (e instanceof INTERNAL) {
                    throw new OBJ_ADAPTER("Unable to resolve ImR");
                }
                if (e instanceof TRANSIENT) {
                    throw (TRANSIENT)((java.lang.Object)e);
                }
                throw new OBJ_ADAPTER(e.toString());
            }
        }
    }

    private void patchAddress(ProfileBase profile, String repId, boolean _transient) {
        if ("IDL:org/jacorb/imr/ImplementationRepository:1.0".equals(repId)) {
            profile.patchPrimaryAddress(this.imrProxyAddress);
        } else if (!_transient && (this.useIMR || this.useTaoIMR)) {
            this.getImR();
            if (this.useIMR) {
                profile.patchPrimaryAddress(this.imr.getImRAddress());
                profile.patchPrimaryAddress(this.imrProxyAddress);
            } else if (this.useTaoIMR) {
                profile.patchPrimaryAddress(this.imr.getImRAddress());
            }
        }
        if (_transient && (this.useIMR || this.useTaoIMR)) {
            this.logger.warn("IMR configured but Object %s is transient", (java.lang.Object)profile.toString());
        }
        profile.patchPrimaryAddress(this.iorProxyAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaggedComponent create_ORB_TYPE_ID() {
        CDROutputStream out = new CDROutputStream((org.omg.CORBA.ORB)this);
        try {
            out.beginEncapsulatedArray();
            out.write_long(1245790976);
            TaggedComponent taggedComponent = new TaggedComponent(0, out.getBufferCopy());
            return taggedComponent;
        }
        finally {
            out.close();
        }
    }

    private synchronized ProtocolAddressBase getServerAddress() {
        ProtocolAddressBase address = this.iorProxyAddress;
        if (address == null) {
            List<Profile> eplist = this.getBasicAdapter().getEndpointProfiles();
            for (Profile p : eplist) {
                if (!(p instanceof IIOPProfile)) continue;
                address = ((IIOPProfile)p).getAddress();
                break;
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Using proxy address " + address.toString() + " in IOR");
        }
        return address;
    }

    @Override
    public void poaStateChanged(org.jacorb.poa.POA poa, int new_state) {
        if ((new_state == 4 || new_state == 3) && poa.isPersistent() && this.imr != null && --this.persistentPOACount == 0) {
            if (this.useIMR) {
                this.imr.setServerDown(this.implName);
            } else if (this.useTaoIMR) {
                this.imr.setServerDown(this, poa, this.implName);
            }
        }
    }

    @Override
    public void referenceCreated(Object o) {
    }

    public boolean get_service_information(short service_type, ServiceInformationHolder service_information) {
        throw new NO_IMPLEMENT();
    }

    @Override
    public Object resolve_initial_references(String identifier) throws InvalidName {
        this.work_pending();
        if (this.initial_references.containsKey(identifier)) {
            return this.initial_references.get(identifier);
        }
        java.lang.Object obj = this.resolveConfigInitRef(identifier);
        if (obj == null) {
            if ("RootPOA".equals(identifier)) {
                return this.getRootPOA();
            }
            if ("POACurrent".equals(identifier)) {
                return this.getPOACurrent();
            }
            if ("SecurityCurrent".equals(identifier)) {
                throw new InvalidName("Level2 SecurityImplementation has been removed");
            }
            if ("DynAnyFactory".equals(identifier)) {
                obj = new DynAnyFactoryImpl(this);
            } else {
                if ("PICurrent".equals(identifier)) {
                    return this.piCurrent;
                }
                if ("ORBPolicyManager".equals(identifier)) {
                    if (this.policyManager == null) {
                        this.policyManager = new PolicyManager(this.getConfiguration());
                    }
                    return this.policyManager;
                }
                if ("CodecFactory".equals(identifier)) {
                    obj = new CodecFactoryImpl(this);
                } else if ("RTORB".equals(identifier)) {
                    obj = this.getRTORB();
                } else {
                    if (this.defaultInitRef != null) {
                        return this.string_to_object(this.defaultInitRef + "/" + identifier);
                    }
                    throw new InvalidName();
                }
            }
        }
        if (obj != null) {
            this.initial_references.put(identifier, (Object)obj);
        }
        return obj;
    }

    private Object resolveConfigInitRef(String identifier) throws InvalidName {
        String url = this.configuration.getAttribute("ORBInitRef." + identifier, null);
        if (url == null) {
            return null;
        }
        try {
            return this.string_to_object(url);
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Could not create initial reference for \"" + identifier + "\"" + System.getProperty("line.separator") + "Please check property \"ORBInitRef." + identifier + '\"', (Throwable)e);
            }
            throw new InvalidName();
        }
    }

    PolicyManager getPolicyManager() {
        return this.policyManager;
    }

    private synchronized RTORB getRTORB() {
        if (this.rtORB == null) {
            this.rtORB = new RTORB(this);
        }
        return this.rtORB;
    }

    public void register_initial_reference(String id, Object obj) throws InvalidName {
        if (id == null || id.length() == 0 || this.initial_references.containsKey(id)) {
            throw new InvalidName();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Registering initial ref " + id);
        }
        this.initial_references.put(id, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.debug("ORB run");
        java.lang.Object object = this.runSync;
        synchronized (object) {
            while (this.run) {
                try {
                    this.runSync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.logger.debug("ORB run, exit");
    }

    @Override
    public void send_multiple_requests_oneway(org.omg.CORBA.Request[] req) {
        this.work_pending();
        for (int i = 0; i < req.length; ++i) {
            req[i].send_oneway();
        }
    }

    @Override
    public void send_multiple_requests_deferred(org.omg.CORBA.Request[] req) {
        this.work_pending();
        for (int i = 0; i < req.length; ++i) {
            req[i].send_deferred();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean poll_next_response() {
        this.work_pending();
        if (this.requests.size() == 0) {
            throw new BAD_INV_ORDER(11, CompletionStatus.COMPLETED_NO);
        }
        Set<org.omg.CORBA.Request> set = this.requests;
        synchronized (set) {
            for (Request request : this.requests) {
                if (!request.poll_response()) continue;
                this.request = request;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.omg.CORBA.Request get_next_response() {
        this.work_pending();
        if (this.requests.size() == 0) {
            throw new BAD_INV_ORDER(11, CompletionStatus.COMPLETED_NO);
        }
        Set<org.omg.CORBA.Request> set = this.requests;
        synchronized (set) {
            Request req = null;
            if (this.request != null) {
                this.request.get_response();
                req = this.request;
                this.request = null;
                return req;
            }
            block3: while (true) {
                Iterator<org.omg.CORBA.Request> iter = this.requests.iterator();
                do {
                    if (!iter.hasNext()) continue block3;
                } while (!(req = (Request)iter.next()).poll_response());
                break;
            }
            req.get_response();
            return req;
        }
    }

    public void addRequest(org.omg.CORBA.Request req) {
        this.requests.add(req);
    }

    public void removeRequest(org.omg.CORBA.Request req) {
        this.requests.remove(req);
    }

    @Override
    protected void set_parameters(String[] args, Properties props) {
        String id = "";
        if (props != null) {
            id = props.getProperty("ORBid", "");
        }
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i].trim();
                if (!arg.equalsIgnoreCase("-ORBID")) continue;
                if (i + 1 < args.length) {
                    if ((id = args[++i]) == null) {
                        throw new INITIALIZE("ORBID cannot be null");
                    }
                    id = id.trim();
                    break;
                }
                throw new INITIALIZE("Invalid number of arguments to ORB.init");
            }
        }
        try {
            this.configure(JacORBConfiguration.getConfiguration(props, this, id, false));
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            this.logger.error("error during configuration", (Throwable)e);
            throw new INITIALIZE(e.getMessage());
        }
        this.orb_id = id;
        this.arguments = args;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initialising ORB with ID: " + this.orb_id);
        }
        Configuration orbsingletonConfig = ((ORBSingleton)org.omg.CORBA.ORBSingleton.init()).configuration;
        if (props != null) {
            orbsingletonConfig.setAttributes(props);
        }
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String propertyValue;
                String propertyName;
                String arg;
                if (args[i] == null || !(arg = args[i].trim()).startsWith("-ORB")) continue;
                if (arg.equalsIgnoreCase("-ORBID")) {
                    ++i;
                    continue;
                }
                if (arg.equalsIgnoreCase("-ORBListenEndpoints")) {
                    ++i;
                    continue;
                }
                if ((arg = arg.substring(1)).equals("ORBDefaultInitRef")) {
                    this.defaultInitRef = args[++i].trim();
                    continue;
                }
                int equals_pos = arg.indexOf(61);
                if (equals_pos == -1) {
                    String prop;
                    if (arg.indexOf(46) >= 0) {
                        throw new BAD_PARAM("-ORBInitRef.xxx yyy is not a valid format. Use -ORBInitRef name=value");
                    }
                    if (i + 1 >= args.length) {
                        throw new BAD_PARAM("Invalid ORBInitRef format: -ORB<option> argument without value");
                    }
                    if ((equals_pos = (prop = args[++i].trim()).indexOf(61)) < 0) {
                        if (arg.equals("ORBInitRef")) {
                            throw new BAD_PARAM("Invalid ORBInitRef format -ORBInitRef " + prop + ". it should be -ORBInitRef name=value.");
                        }
                        propertyName = arg;
                        propertyValue = prop;
                    } else {
                        propertyName = arg + "." + prop.substring(0, equals_pos);
                        propertyValue = prop.substring(equals_pos + 1);
                        if (propertyValue.length() == 0) {
                            throw new BAD_PARAM("Invalid ORBInitRef format: -ORBInitRef name=value. value may not be omitted.");
                        }
                    }
                } else {
                    propertyName = arg.substring(0, equals_pos);
                    propertyValue = arg.substring(equals_pos + 1);
                    if (propertyValue.length() == 0) {
                        throw new BAD_PARAM("Invalid ORBInitRef format: -ORBInitRef name=value. value may not be omitted.");
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("adding attribute " + propertyName + "=" + propertyValue);
                }
                this.configuration.setAttribute(propertyName, propertyValue);
                orbsingletonConfig.setAttribute(propertyName, propertyValue);
            }
        }
        this.internalInit();
    }

    @Override
    protected void set_parameters(Applet app, Properties props) {
        String id = "";
        if (props != null) {
            id = props.getProperty("ORBid", "");
        }
        try {
            this.configure(JacORBConfiguration.getConfiguration(props, this, id, true));
        }
        catch (ConfigurationException e) {
            this.logger.error("configuration exception during configure", (Throwable)e);
            throw new INITIALIZE(e.toString());
        }
        this.orb_id = id;
        this.internalInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalInit() {
        this.inORBInitializer = true;
        try {
            List<ORBInitializer> orb_initializers = this.getORBInitializers();
            if (this.configuration.getAttributeAsBoolean("jacorb.codeset", true)) {
                boolean found = false;
                for (ORBInitializer oi : orb_initializers) {
                    if (!(oi instanceof IORInterceptorInitializer)) continue;
                    found = true;
                    this.logger.debug("Adding IORInterceptorInitializer manually is deprecated.");
                }
                if (!found) {
                    orb_initializers.add(new IORInterceptorInitializer());
                }
            }
            ORBInitInfoImpl initInfo = new ORBInitInfoImpl(this);
            this.initManagers();
            this.interceptorPreInit(orb_initializers, initInfo);
            this.initKnownReferencesMap();
            this.interceptorPostInit(orb_initializers, initInfo);
            this.internalInit(initInfo);
        }
        finally {
            this.inORBInitializer = false;
        }
    }

    private void initManagers() {
        try {
            if (this.useSelectorManager) {
                try {
                    this.selectorManager = new SelectorManager();
                    this.selectorManager.configure(this.configuration);
                    this.selectorManager.start();
                    this.timer_queue = new TimerQueue(this.selectorManager);
                }
                catch (Exception e) {
                    throw new ConfigurationException("SelectorManager initialization failed", e);
                }
            }
            this.transport_manager = new TransportManager();
            this.transport_manager.configure(this.configuration);
            this.giop_connection_manager = new GIOPConnectionManager();
            this.giop_connection_manager.configure(this.configuration);
            this.clientConnectionManager = new ClientConnectionManager(this, this.transport_manager, this.giop_connection_manager);
            this.clientConnectionManager.configure(this.configuration);
        }
        catch (ConfigurationException ce) {
            this.logger.error("Unexpected exception configuring managers", (Throwable)ce);
            throw new INTERNAL(ce.toString());
        }
    }

    private void initKnownReferencesMap() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Property \"jacorb.hashtable_class\" is set to: " + this.hashTableClassName);
        }
        try {
            this.knownReferences = (Map)ObjectUtil.classForName(this.hashTableClassName).newInstance();
        }
        catch (Exception e) {
            this.logger.error("unable to create known references map", (Throwable)e);
            throw new INTERNAL(e.toString());
        }
    }

    private void internalInit(ORBInitInfoImpl info) {
        info.setInvalid();
        List<Interceptor> client_interceptors = info.getClientInterceptors();
        List<Interceptor> server_interceptors = info.getServerInterceptors();
        List<Interceptor> ior_intercept = info.getIORInterceptors();
        this.hasClientInterceptors = !client_interceptors.isEmpty();
        boolean bl = this.hasServerInterceptors = !server_interceptors.isEmpty();
        if (this.hasClientInterceptors || this.hasServerInterceptors || !ior_intercept.isEmpty()) {
            this.interceptor_manager = new InterceptorManager(client_interceptors, server_interceptors, ior_intercept, info.getSlotCount(), this);
        }
        this.policy_factories.putAll(info.getPolicyFactories());
    }

    private void interceptorPreInit(List<ORBInitializer> orb_initializers, ORBInitInfo info) {
        Iterator<ORBInitializer> i = orb_initializers.iterator();
        while (i.hasNext()) {
            ORBInitializer initializer = i.next();
            try {
                initializer.pre_init(info);
            }
            catch (Exception e) {
                if (this.failOnORBInitializerError) {
                    this.logger.error(initializer.getClass().getName() + ": aborting due to error during ORBInitializer::pre_init", (Throwable)e);
                    throw new INITIALIZE(e.toString());
                }
                this.logger.warn(initializer.getClass().getName() + ": ignoring error during ORBInitializer::pre_init. the ORBInitializer will be removed from the current configuration", (Throwable)e);
                i.remove();
            }
        }
    }

    private void interceptorPostInit(List<ORBInitializer> orb_initializers, ORBInitInfo info) {
        for (ORBInitializer initializer : orb_initializers) {
            try {
                initializer.post_init(info);
            }
            catch (Exception e) {
                if (this.failOnORBInitializerError) {
                    this.logger.error(initializer.getClass().getName() + ": aborting due to error during ORBInitializer::post_init", (Throwable)e);
                    throw new INITIALIZE(e.toString());
                }
                this.logger.warn(initializer.getClass().getName() + ": ignoring error during ORBInitializer::post_init. the ORBInitializer will be removed from the current configuration", (Throwable)e);
            }
        }
    }

    private List<ORBInitializer> getORBInitializers() {
        ArrayList<ORBInitializer> orb_initializers = new ArrayList<ORBInitializer>();
        String initializer_prefix = "org.omg.PortableInterceptor.ORBInitializerClass.";
        List<String> prop_names = this.configuration.getAttributeNamesWithPrefix("org.omg.PortableInterceptor.ORBInitializerClass.");
        for (String prop_name : prop_names) {
            String name = this.configuration.getAttribute(prop_name, "");
            if (name.length() == 0 && prop_name.length() > "org.omg.PortableInterceptor.ORBInitializerClass.".length()) {
                name = prop_name.substring("org.omg.PortableInterceptor.ORBInitializerClass.".length());
            }
            if (name == null) continue;
            try {
                java.lang.Object newInstance = ObjectUtil.classForName(name).newInstance();
                if (newInstance instanceof ORBInitializer) {
                    orb_initializers.add((ORBInitializer)newInstance);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("added ORBInitializer: " + name);
                    continue;
                }
                if (this.failOnORBInitializerError) {
                    this.logger.error("aborting due to wrong configuration for property " + prop_name + ": " + name + " is not an ORBInitializer");
                    throw new BAD_PARAM("Wrong configuration for property " + prop_name + ": " + name + " is not an ORBInitializer");
                }
                this.logger.warn("ignoring wrong configuration for property " + prop_name + ": " + name + " is not an ORBInitializer");
            }
            catch (Exception e) {
                if (this.failOnORBInitializerError) {
                    this.logger.error("unable to build ORBInitializer from class " + name + ": Aborting", (Throwable)e);
                    throw new INITIALIZE(e.toString());
                }
                this.logger.warn("unable to build ORBInitializer from class " + name + ": Ignoring");
            }
        }
        return orb_initializers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean wait_for_completion) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("prepare ORB for shutdown...");
        }
        java.lang.Object object = this.shutdown_synch;
        synchronized (object) {
            if (this.shutdown_in_progress && !wait_for_completion) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ORB is already shutting down.");
                }
                return;
            }
            while (this.shutdown_in_progress) {
                try {
                    this.shutdown_synch.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.shutdown_in_progress = true;
        }
        if (!this.isRunning()) {
            object = this.shutdown_synch;
            synchronized (object) {
                this.shutdown_in_progress = false;
                this.shutdown_synch.notifyAll();
            }
            return;
        }
        if (this.rootpoa != null) {
            this.rootpoa.destroy(true, wait_for_completion);
            this.rootpoa = null;
        }
        if (this.basicAdapter != null) {
            this.basicAdapter.stopListeners();
        }
        if (this.giop_connection_manager != null) {
            this.giop_connection_manager.shutdown();
        }
        this.clientConnectionManager.shutdown();
        this.knownReferences.clear();
        this.bufferManager.release();
        this.poolManagerFactory.destroy();
        if (this.interceptor_manager != null) {
            this.interceptor_manager.destroy();
        }
        object = this.runSync;
        synchronized (object) {
            this.run = false;
            this.runSync.notifyAll();
        }
        object = this.shutdown_synch;
        synchronized (object) {
            this.shutdown_in_progress = false;
            this.shutdown_synch.notifyAll();
        }
        if (this.useSelectorManager) {
            this.selectorManager.halt();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB shutdown complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.destroyed) {
            throw new OBJECT_NOT_EXIST();
        }
        java.lang.Object object = this.runSync;
        synchronized (object) {
            if (this.run) {
                this.shutdown(true);
            }
        }
        this.destroyed = true;
    }

    @Override
    public Object string_to_object(String str) {
        this.work_pending();
        if (str == null) {
            return null;
        }
        try {
            ParsedIOR pior = new ParsedIOR(this, str);
            if (pior.isNull()) {
                return null;
            }
            return this._getDelegate(pior);
        }
        catch (Exception e) {
            this.logger.error("Exception while converting string to object", (Throwable)e);
            throw new BAD_PARAM(10, CompletionStatus.COMPLETED_NO);
        }
    }

    public Object get_value_def(String repid) throws BAD_PARAM {
        throw new NO_IMPLEMENT();
    }

    public void set_delegate(java.lang.Object wrapper) {
        if (!(wrapper instanceof Servant)) {
            throw new BAD_PARAM("Argument must be of type org.omg.PortableServer.Servant");
        }
        try {
            ((Servant)wrapper)._get_delegate();
        }
        catch (BAD_INV_ORDER bio) {
            ServantDelegate delegate = new ServantDelegate(this);
            ((Servant)wrapper)._set_delegate((org.omg.PortableServer.portable.Delegate)delegate);
        }
        if (((Servant)wrapper)._get_delegate().orb((Servant)wrapper) != this) {
            ServantDelegate delegate = new ServantDelegate(this);
            ((Servant)wrapper)._set_delegate((org.omg.PortableServer.portable.Delegate)delegate);
        }
    }

    @Override
    public String object_to_string(Object obj) {
        this.work_pending();
        if (obj == null) {
            return nullIORString;
        }
        if (obj instanceof LocalObject) {
            throw new MARSHAL("Attempt to stringify a local object");
        }
        org.omg.CORBA.portable.Delegate delegate = ((ObjectImpl)obj)._get_delegate();
        if (delegate instanceof Delegate) {
            return delegate.toString();
        }
        throw new BAD_PARAM("Argument has a delegate whose class is " + delegate.getClass().getName() + ", a org.jacorb.orb.Delegate was expected");
    }

    @Override
    public void perform_work() {
        this.work_pending();
    }

    @Override
    public boolean work_pending() {
        if (!this.isRunning()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ORB has been shutdown");
            }
            throw new BAD_INV_ORDER(4, CompletionStatus.COMPLETED_NO);
        }
        return false;
    }

    public synchronized ValueFactory register_value_factory(String id, ValueFactory factory) {
        return this.valueFactories.put(id, factory);
    }

    public synchronized void unregister_value_factory(String id) {
        this.valueFactories.remove(id);
    }

    public synchronized ValueFactory lookup_value_factory(String id) {
        ValueFactory result = this.valueFactories.get(id);
        if (result == null && id.startsWith("IDL")) {
            String valueName = RepositoryID.className(id, null);
            result = this.findValueFactory(valueName);
            this.valueFactories.put(id, result);
        }
        return result;
    }

    private ValueFactory findValueFactory(String valueName) {
        Class result = this.findClass(valueName + "DefaultFactory", true);
        if (result != null) {
            return (ValueFactory)this.instantiate(result);
        }
        Class clazz = this.findClass(valueName, false);
        result = this.findClass(valueName + "Impl", false);
        if (result != null && clazz.isAssignableFrom(result)) {
            if (ValueFactory.class.isAssignableFrom(result)) {
                return (ValueFactory)this.instantiate(result);
            }
            return new JacORBValueFactory(result);
        }
        return null;
    }

    private Class findClass(String name, boolean orgomg) {
        Class<?> result;
        block4: {
            result = null;
            try {
                result = ObjectUtil.classForName(name);
            }
            catch (ClassNotFoundException e) {
                if (!orgomg || !name.startsWith("org.omg")) break block4;
                try {
                    result = ObjectUtil.classForName("omg.org" + name.substring(7));
                }
                catch (ClassNotFoundException x) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private java.lang.Object instantiate(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("cannot instantiate class " + clazz.getName() + " (IllegalAccessException)");
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("cannot instantiate class " + clazz.getName() + " (InstantiationException)");
        }
    }

    public BoxedValueHelper getBoxedValueHelper(String repId) {
        BoxedValueHelper result = this.boxedValueHelpers.get(repId);
        if (result == null) {
            if (this.boxedValueHelpers.containsKey(repId)) {
                return null;
            }
            result = RepositoryID.createBoxedValueHelper(repId, null);
            this.boxedValueHelpers.put(repId, result);
        }
        return result;
    }

    public boolean hasClientRequestInterceptors() {
        return this.hasClientInterceptors;
    }

    public boolean hasServerRequestInterceptors() {
        return this.hasServerInterceptors;
    }

    public boolean hasRequestInterceptors() {
        return this.hasServerInterceptors || this.hasClientInterceptors;
    }

    public InterceptorManager getInterceptorManager() {
        return this.interceptor_manager;
    }

    public TransportManager getTransportManager() {
        return this.transport_manager;
    }

    public TimerQueue getTimerQueue() {
        return this.timer_queue;
    }

    public SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    @Override
    public org.omg.CORBA.ExceptionList create_exception_list() {
        this.work_pending();
        return new ExceptionList();
    }

    @Override
    public org.omg.CORBA.NVList create_list(int count) {
        this.work_pending();
        return new NVList((org.omg.CORBA.ORB)this, count);
    }

    @Override
    public org.omg.CORBA.NamedValue create_named_value(String name, Any value, int flags) {
        this.work_pending();
        return new NamedValue(name, value, flags);
    }

    @Override
    public org.omg.CORBA.NVList create_operation_list(Object obj) {
        this.work_pending();
        if (!(obj instanceof OperationDef)) {
            throw new BAD_PARAM("Argument must be of type org.omg.CORBA.OperationDef");
        }
        OperationDef oper = (OperationDef)obj;
        return this.create_operation_list(oper);
    }

    @Override
    @Deprecated
    public org.omg.CORBA.NVList create_operation_list(OperationDef oper) {
        int no = 0;
        this.work_pending();
        ParameterDescription[] params = oper.params();
        if (params != null) {
            no = params.length;
        }
        NVList list = new NVList((org.omg.CORBA.ORB)this, no);
        block5: for (int i = 0; i < no; ++i) {
            ParameterDescription param = params[i];
            Any any = this.create_any();
            any.type(param.type);
            switch (param.mode.value()) {
                case 0: {
                    list.add_value(param.name, any, 1);
                    continue block5;
                }
                case 1: {
                    list.add_value(param.name, any, 2);
                    continue block5;
                }
                case 2: {
                    list.add_value(param.name, any, 3);
                    continue block5;
                }
                default: {
                    throw new BAD_PARAM("Invalid value for ParamaterMode");
                }
            }
        }
        return list;
    }

    private void configureObjectKeyMap(Configuration config) {
        this.objectKeyMap.configureObjectKeyMap(config);
    }

    public void addObjectKey(String key_name, String full_path) {
        this.objectKeyMap.addObjectKey(key_name, full_path);
    }

    public void addObjectKey(String key_name, Object target) {
        this.objectKeyMap.addObjectKey(key_name, target);
    }

    public byte[] mapObjectKey(byte[] originalKey) {
        return this.objectKeyMap.mapObjectKey(originalKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunning() {
        java.lang.Object object = this.runSync;
        synchronized (object) {
            return this.run;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Object obj) {
        this.work_pending();
        if (!(obj instanceof ObjectImpl)) {
            throw new BAD_PARAM("connect parameter must extend org.omg.CORBA.portable.ObjectImpl");
        }
        if (!(obj instanceof InvokeHandler)) {
            throw new BAD_PARAM("connect parameter must implement org.omg.CORBA.portable.InvokeHandler");
        }
        Map map = this.connectedObjects;
        synchronized (map) {
            if (!this.connectedObjects.containsKey(obj)) {
                ObjectImpl objectImpl = (ObjectImpl)obj;
                HandlerWrapper servant = new HandlerWrapper(objectImpl);
                Object ref = servant._this_object((org.omg.CORBA.ORB)this);
                objectImpl._set_delegate(((ObjectImpl)ref)._get_delegate());
                this.connectedObjects.put(obj, servant);
                if (this.firstConnection) {
                    this.firstConnection = false;
                    POAManager rootPOAManager = this.getRootPOA().the_POAManager();
                    if (rootPOAManager.get_state() == State.HOLDING) {
                        try {
                            rootPOAManager.activate();
                        }
                        catch (AdapterInactive e) {
                            this.logger.error("unexpected exception", (Throwable)e);
                            throw new INTERNAL(e.toString());
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(Object obj) {
        this.work_pending();
        if (!(obj instanceof ObjectImpl)) {
            throw new BAD_PARAM("disconnect parameter must extend org.omg.CORBA.portable.ObjectImpl");
        }
        if (!(obj instanceof InvokeHandler)) {
            throw new BAD_PARAM("disconnect parameter must implement org.omg.CORBA.portable.InvokeHandler");
        }
        Map map = this.connectedObjects;
        synchronized (map) {
            Servant servant = (Servant)this.connectedObjects.get(obj);
            if (servant != null) {
                this.connectedObjects.remove(obj);
                try {
                    this.getRootPOA().deactivate_object(this.getRootPOA().servant_to_id(servant));
                }
                catch (Exception e) {
                    this.logger.error("unexpected exception", (Throwable)e);
                    throw new INTERNAL(e.toString());
                }
            }
        }
    }

    public String getServerIdString() {
        return this.serverIdStr;
    }

    public byte[] getServerId() {
        return this.serverId;
    }

    public RPPoolManager newRPPoolManager(boolean isSingleThreaded) {
        return this.poolManagerFactory.newRPPoolManager(isSingleThreaded);
    }

    public void notifyTransportListeners(GIOPConnection gc) {
        this.transport_manager.notifyTransportListeners(gc);
    }

    public String getImplName() {
        return this.implName;
    }

    public String[] getArgs() {
        return this.arguments;
    }

    public int getGIOPMinorVersion() {
        return this.giopMinorVersion;
    }

    static class HandlerWrapper
    extends Servant
    implements InvokeHandler {
        private final InvokeHandler wrappedHandler;

        public HandlerWrapper(ObjectImpl objectImpl) {
            this.wrappedHandler = (InvokeHandler)objectImpl;
        }

        public String[] _all_interfaces(POA poa, byte[] objectID) {
            return ((ObjectImpl)this.wrappedHandler)._ids();
        }

        public OutputStream _invoke(String method, org.omg.CORBA.portable.InputStream input, ResponseHandler handler) throws SystemException {
            return this.wrappedHandler._invoke(method, input, handler);
        }
    }

    private class PICurrent
    extends LocalObject
    implements org.omg.PortableInterceptor.Current {
        private PICurrent() {
        }

        private org.omg.PortableInterceptor.Current getTarget() {
            if (ORB.this.interceptor_manager == null) {
                if (ORB.this.inORBInitializer) {
                    throw new BAD_INV_ORDER("set_slot/get_slot may not be invoked from within an ORB initializer", 10, CompletionStatus.COMPLETED_NO);
                }
                return InterceptorManager.EMPTY_CURRENT;
            }
            return ORB.this.interceptor_manager.getCurrent();
        }

        public Any get_slot(int id) throws InvalidSlot {
            return this.getTarget().get_slot(id);
        }

        public void set_slot(int id, Any data) throws InvalidSlot {
            this.getTarget().set_slot(id, data);
        }
    }

    private class JacORBValueFactory
    implements ValueFactory {
        private final Class implementationClass;

        public JacORBValueFactory(Class clazz) {
            this.implementationClass = clazz;
        }

        public Serializable read_value(InputStream is) {
            java.lang.Object implObj = ORB.this.instantiate(this.implementationClass);
            if (implObj instanceof Streamable) {
                StreamableValue value = (StreamableValue)ORB.this.instantiate(this.implementationClass);
                return is.read_value((Serializable)value);
            }
            if (implObj instanceof CustomValue) {
                ((CustomValue)implObj).unmarshal((org.omg.CORBA.DataInputStream)new DataInputStream((org.omg.CORBA.portable.InputStream)is));
                return (CustomValue)implObj;
            }
            throw new MARSHAL("Unknown Value type " + implObj);
        }
    }
}

