/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.ServiceContextTransportingOutputStream;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.GIOP.ReplyStatusType_1_0;
import org.omg.GIOP.ReplyStatusType_1_0Helper;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.GIOP.ReplyStatusType_1_2Helper;
import org.omg.IOP.IORHelper;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHelper;
import org.slf4j.Logger;

public class ReplyOutputStream
extends ServiceContextTransportingOutputStream {
    private final boolean is_locate_reply;
    private final Logger logger;

    public ReplyOutputStream(ORB orb, int request_id, ReplyStatusType_1_2 reply_status, int giop_minor, boolean is_locate_reply, Logger logger) {
        super(orb);
        this.logger = logger;
        this.is_locate_reply = is_locate_reply;
        this.setGIOPMinor(giop_minor);
        this.writeGIOPMsgHeader(1, giop_minor);
        switch (giop_minor) {
            case 0: 
            case 1: {
                ServiceContextListHelper.write((OutputStream)this, (ServiceContext[])Messages.service_context);
                this.write_ulong(request_id);
                ReplyStatusType_1_0Helper.write((OutputStream)this, (ReplyStatusType_1_0)ReplyStatusType_1_0.from_int((int)reply_status.value()));
                break;
            }
            case 2: {
                this.write_ulong(request_id);
                ReplyStatusType_1_2Helper.write((OutputStream)this, (ReplyStatusType_1_2)reply_status);
                ServiceContextListHelper.write((OutputStream)this, (ServiceContext[])Messages.service_context);
                this.markHeaderEnd();
                break;
            }
            default: {
                throw new MARSHAL("Unknown GIOP minor: " + giop_minor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write_to(GIOPConnection conn) throws IOException {
        block7: {
            if (this.is_locate_reply) {
                ReplyInputStream in = new ReplyInputStream((ORB)this.orb, this.getBufferCopy());
                try {
                    LocateReplyOutputStream out = this.getLocateReplyOutputStream(in);
                    try {
                        out.write_to(conn);
                        break block7;
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    in.close();
                }
            }
            super.write_to(conn);
        }
    }

    private LocateReplyOutputStream getLocateReplyOutputStream(ReplyInputStream replyInputStream) {
        LocateReplyOutputStream result;
        block14: {
            block13: {
                if (replyInputStream.getGIOPMinor() >= 2) break block13;
                switch (replyInputStream.rep_hdr.reply_status.value()) {
                    case 0: {
                        int status = replyInputStream.read_boolean() ? 0 : 1;
                        result = new LocateReplyOutputStream((ORB)this.orb, replyInputStream.rep_hdr.request_id, status, replyInputStream.getGIOPMinor());
                        break block14;
                    }
                    case 1: 
                    case 2: {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("Received an exception when processing a LocateRequest");
                        }
                        result = new LocateReplyOutputStream((ORB)this.orb, replyInputStream.rep_hdr.request_id, 0, replyInputStream.getGIOPMinor());
                        break block14;
                    }
                    case 3: {
                        result = new LocateReplyOutputStream((ORB)this.orb, replyInputStream.rep_hdr.request_id, 2, replyInputStream.getGIOPMinor());
                        result.write_IOR(IORHelper.read((InputStream)replyInputStream));
                        break block14;
                    }
                    default: {
                        throw new IllegalArgumentException("ReplyStatus is invalid");
                    }
                }
            }
            switch (replyInputStream.rep_hdr.reply_status.value()) {
                case 0: {
                    int status = replyInputStream.read_boolean() ? 0 : 1;
                    result = new LocateReplyOutputStream((ORB)this.orb, replyInputStream.rep_hdr.request_id, status, replyInputStream.getGIOPMinor());
                    break;
                }
                case 1: {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("Received an exception when processing a LocateRequest - mapping to UNKNOWN system exception");
                    }
                    result = new LocateReplyOutputStream((ORB)this.orb, replyInputStream.rep_hdr.request_id, 4, replyInputStream.getGIOPMinor());
                    SystemExceptionHelper.write((OutputStream)result, (SystemException)new UNKNOWN());
                    break;
                }
                case 2: {
                    result = new LocateReplyOutputStream((ORB)this.orb, replyInputStream.rep_hdr.request_id, 4, replyInputStream.getGIOPMinor());
                    SystemExceptionHelper.write((OutputStream)result, SystemExceptionHelper.read((InputStream)replyInputStream));
                    break;
                }
                case 3: {
                    result = new LocateReplyOutputStream((ORB)this.orb, replyInputStream.rep_hdr.request_id, 2, replyInputStream.getGIOPMinor());
                    result.write_IOR(IORHelper.read((InputStream)replyInputStream));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("ReplyStatus is invalid");
                }
            }
        }
        return result;
    }
}

