/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.ClientInterceptorIterator;
import org.jacorb.orb.portableInterceptor.IORInterceptorIterator;
import org.jacorb.orb.portableInterceptor.PICurrentImpl;
import org.jacorb.orb.portableInterceptor.ServerInterceptorIterator;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.slf4j.Logger;

public class InterceptorManager {
    private static final Comparator INTERCEPTOR_COMPARATOR = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            Interceptor left = (Interceptor)arg0;
            Interceptor right = (Interceptor)arg1;
            return left.name().compareTo(right.name());
        }
    };
    private final Interceptor[] client_req_interceptors;
    private final Interceptor[] server_req_interceptors;
    private final Interceptor[] ior_interceptors;
    private final org.omg.CORBA.ORB orb;
    private final int current_slots;
    private final Logger logger;
    private final ThreadLocal<Current> piCurrent = new ThreadLocal();
    private final ThreadLocal<Current> localPICurrent = new ThreadLocal();
    public static final PICurrentImpl EMPTY_CURRENT = new PICurrentImpl(null, 0);

    public InterceptorManager(List<Interceptor> client_interceptors, List<Interceptor> server_interceptors, List<Interceptor> ior_intercept, int slot_count, ORB orb) {
        this.logger = orb.getConfiguration().getLogger("org.jacorb.orb.interceptors");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("InterceptorManager started with " + server_interceptors.size() + " Server Interceptors, " + client_interceptors.size() + " Client Interceptors and " + ior_intercept.size() + " IOR Interceptors");
        }
        this.client_req_interceptors = (Interceptor[])client_interceptors.toArray(new ClientRequestInterceptor[client_interceptors.size()]);
        Arrays.sort(this.client_req_interceptors, INTERCEPTOR_COMPARATOR);
        this.server_req_interceptors = (Interceptor[])server_interceptors.toArray(new ServerRequestInterceptor[server_interceptors.size()]);
        Arrays.sort(this.server_req_interceptors, INTERCEPTOR_COMPARATOR);
        this.ior_interceptors = (Interceptor[])ior_intercept.toArray(new IORInterceptor[ior_intercept.size()]);
        Arrays.sort(this.ior_interceptors, INTERCEPTOR_COMPARATOR);
        this.orb = orb;
        this.current_slots = slot_count;
    }

    public Current getCurrent() {
        Current value = null;
        if (this.localPICurrent.get() != null) {
            value = this.localPICurrent.get();
        }
        if (value == null && (value = this.piCurrent.get()) == null) {
            value = this.getEmptyCurrent();
            this.piCurrent.set(value);
        }
        return value;
    }

    public boolean hasCurrent() {
        return this.piCurrent.get() != null;
    }

    public void setLocalPICurrent(Current localCurrent) {
        this.localPICurrent.set(localCurrent);
    }

    public void removeLocalPICurrent() {
        this.localPICurrent.set(null);
    }

    public void setTSCurrent(Current current) {
        this.piCurrent.set(current);
    }

    public void removeTSCurrent() {
        this.piCurrent.set(null);
    }

    public Current getEmptyCurrent() {
        return new PICurrentImpl(this.orb, this.current_slots);
    }

    public ClientInterceptorIterator getClientIterator() {
        return new ClientInterceptorIterator(this.logger, this.client_req_interceptors);
    }

    public ServerInterceptorIterator getServerIterator() {
        return new ServerInterceptorIterator(this.server_req_interceptors);
    }

    public IORInterceptorIterator getIORIterator() {
        return new IORInterceptorIterator(this.logger, this.ior_interceptors);
    }

    public boolean hasClientRequestInterceptors() {
        return this.client_req_interceptors.length > 0;
    }

    public boolean hasServerRequestInterceptors() {
        return this.server_req_interceptors.length > 0;
    }

    public boolean hasIORInterceptors() {
        return this.ior_interceptors.length > 0;
    }

    public void destroy() {
        int i;
        if (this.hasClientRequestInterceptors()) {
            for (i = 0; i < this.client_req_interceptors.length; ++i) {
                this.client_req_interceptors[i].destroy();
            }
        }
        if (this.hasServerRequestInterceptors()) {
            for (i = 0; i < this.server_req_interceptors.length; ++i) {
                this.server_req_interceptors[i].destroy();
            }
        }
        if (this.hasIORInterceptors()) {
            for (i = 0; i < this.ior_interceptors.length; ++i) {
                this.ior_interceptors[i].destroy();
            }
        }
        this.piCurrent.set(null);
        this.localPICurrent.set(null);
    }
}

