/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.ArrayDeclarator;
import org.jacorb.idl.ArrayTypeSpec;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Declaration;
import org.jacorb.idl.Declarator;
import org.jacorb.idl.IDLTypes;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.Interface;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SequenceType;
import org.jacorb.idl.StructType;
import org.jacorb.idl.SymbolList;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.Value;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class Member
extends Declaration {
    public TypeSpec type_spec;
    SymbolList declarators;
    public Vector extendVector;
    public TypeDeclaration containingType;
    public Declarator declarator;

    public Member(int num) {
        super(num);
    }

    @Override
    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        this.type_spec.setPackage(s);
        if (this.declarators != null) {
            this.declarators.setPackage(s);
        }
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        this.enclosing_symbol = s;
        this.type_spec.setEnclosingSymbol(s);
        Enumeration e = this.declarators.v.elements();
        while (e.hasMoreElements()) {
            ((Declarator)e.nextElement()).setEnclosingSymbol(s);
        }
    }

    public void setContainingType(TypeDeclaration t) {
        this.containingType = t;
    }

    public void setExtendVector(Vector v) {
        this.extendVector = v;
    }

    public Member extractMember(Declarator d) {
        Member result = new Member(Member.new_num());
        result.declarator = d;
        return result;
    }

    @Override
    public void parse() {
        boolean clone_and_parse = true;
        if (this.extendVector == null) {
            lexer.restorePosition(this.myPosition);
            parser.fatal_error("Internal Compiler Error: extendVector not set.", this.token);
        }
        if (this.type_spec.typeSpec() instanceof ScopedName) {
            SequenceType sequenceTS;
            AliasTypeSpec aliasTS;
            TypeSpec originalType;
            this.token = this.type_spec.typeSpec().get_token();
            String name = this.type_spec.typeSpec().toString();
            this.type_spec = ((ScopedName)this.type_spec.typeSpec()).resolvedTypeSpec();
            this.enclosing_symbol.addImportedName(name, this.type_spec);
            if (this.type_spec instanceof AliasTypeSpec && (originalType = (aliasTS = (AliasTypeSpec)this.type_spec).originalType()) instanceof SequenceType && (sequenceTS = (SequenceType)originalType).elementTypeSpec().typeName().equals(this.containingType.typeName())) {
                sequenceTS.setRecursive();
            }
            clone_and_parse = false;
            if (this.type_spec instanceof ConstrTypeSpec && ((ConstrTypeSpec)this.type_spec.typeSpec()).c_type_spec instanceof StructType && ((ConstrTypeSpec)this.type_spec.typeSpec()).c_type_spec.typeName().equals(this.containingType.typeName())) {
                parser.fatal_error("Illegal type recursion (use sequence<" + this.containingType.typeName() + "> instead)", this.token);
            }
        } else if (this.type_spec.typeSpec() instanceof SequenceType) {
            TypeSpec ts = ((SequenceType)this.type_spec.typeSpec()).elementTypeSpec().typeSpec();
            SequenceType seqTs = (SequenceType)this.type_spec.typeSpec();
            while (ts instanceof SequenceType) {
                seqTs = (SequenceType)ts;
                ts = ((SequenceType)ts.typeSpec()).elementTypeSpec().typeSpec();
            }
            if (ScopedName.isRecursionScope(ts.typeName())) {
                seqTs.setRecursive();
            }
        } else if (this.type_spec instanceof ConstrTypeSpec) {
            this.type_spec.parse();
        }
        String tokName = null;
        if (this.token != null && this.token.line_val != null && (tokName = this.token.line_val.trim()).length() == 0) {
            tokName = null;
        }
        Enumeration e = this.declarators.v.elements();
        while (e.hasMoreElements()) {
            Declarator declarator = (Declarator)e.nextElement();
            String declaratorName = declarator.name();
            if (tokName != null) {
                if (parser.strict_names) {
                    if (declaratorName.equalsIgnoreCase(tokName)) {
                        parser.fatal_error("Declarator " + declaratorName + " already defined in scope.", this.token);
                    }
                } else if (declaratorName.equals(tokName)) {
                    parser.fatal_error("Declarator " + declaratorName + " already defined in scope.", this.token);
                }
            }
            Member m = this.extractMember(declarator);
            TypeSpec ts = this.type_spec.typeSpec();
            if (clone_and_parse || declarator.d instanceof ArrayDeclarator) {
                if (declarator.d instanceof ArrayDeclarator) {
                    ts = new ArrayTypeSpec(Member.new_num(), ts, (ArrayDeclarator)declarator.d, this.pack_name);
                    ts.parse();
                } else if (!(ts instanceof BaseType)) {
                    if (!((ts = (TypeSpec)ts.clone()) instanceof ConstrTypeSpec)) {
                        ts.set_name(declarator.name());
                    }
                    if (!e.hasMoreElements()) {
                        ts.parse();
                    }
                }
            }
            if (!(declarator.d instanceof ArrayDeclarator)) {
                try {
                    NameTable.define(this.containingType + "." + declarator.name(), IDLTypes.DECLARATOR);
                }
                catch (NameAlreadyDefined nad) {
                    parser.fatal_error("Declarator " + declarator.name() + " already defined in scope.", this.token);
                }
            }
            m.type_spec = ts;
            m.pack_name = this.pack_name;
            m.name = declaratorName;
            this.extendVector.addElement(m);
        }
        this.declarators = null;
    }

    @Override
    public void print(PrintWriter ps) {
        this.member_print(ps, "\tpublic ");
    }

    public void member_print(PrintWriter ps, String prefix) {
        if (this.type_spec.typeSpec() instanceof ConstrTypeSpec && !(((ConstrTypeSpec)this.type_spec.typeSpec()).c_type_spec.declaration() instanceof Interface) && !(((ConstrTypeSpec)this.type_spec.typeSpec()).c_type_spec.declaration() instanceof Value) || this.type_spec.typeSpec() instanceof SequenceType || this.type_spec.typeSpec() instanceof ArrayTypeSpec) {
            this.type_spec.print(ps);
        }
        if (this.type_spec.typeSpec().toString().equals("java.lang.String")) {
            ps.print(prefix + this.type_spec.toString() + " " + this.declarator.toString() + " = \"\";");
        } else {
            ps.print(prefix + this.type_spec.toString() + " " + this.declarator.toString() + ";");
        }
    }

    public TypeSpec typeSpec() {
        return this.type_spec.typeSpec();
    }
}

