/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.monitors;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.monitors.AbstractComponentMonitor;
import org.picocontainer.monitors.DefaultComponentMonitor;

public class ConsoleComponentMonitor
extends AbstractComponentMonitor {
    private PrintStream out;
    private final ComponentMonitor delegate;

    public ConsoleComponentMonitor(OutputStream outputStream) {
        this.out = new PrintStream(outputStream);
        this.delegate = new DefaultComponentMonitor();
    }

    public ConsoleComponentMonitor(OutputStream outputStream, ComponentMonitor componentMonitor) {
        this.out = new PrintStream(outputStream);
        this.delegate = new DefaultComponentMonitor();
    }

    public void instantiating(Constructor constructor) {
        this.out.println(ConsoleComponentMonitor.format("PicoContainer: instantiating {0}", new Object[]{constructor}));
        this.delegate.instantiating(constructor);
    }

    public void instantiated(Constructor constructor, long l) {
        this.out.println(ConsoleComponentMonitor.format("PicoContainer: instantiated {0} [{1} ms]", new Object[]{constructor, new Long(l)}));
        this.delegate.instantiated(constructor, l);
    }

    public void instantiationFailed(Constructor constructor, Exception exception) {
        this.out.println(ConsoleComponentMonitor.format("PicoContainer: instantiation failed: {0}, reason: {1}", new Object[]{constructor, exception.getMessage()}));
        this.delegate.instantiationFailed(constructor, exception);
    }

    public void invoking(Method method, Object object) {
        this.out.println(ConsoleComponentMonitor.format("PicoContainer: invoking {0} on {1}", new Object[]{method, object}));
        this.delegate.invoking(method, object);
    }

    public void invoked(Method method, Object object, long l) {
        this.out.println(ConsoleComponentMonitor.format("PicoContainer: invoked {0} on {1} [{2} ms]", new Object[]{method, object, new Long(l)}));
        this.delegate.invoked(method, object, l);
    }

    public void invocationFailed(Method method, Object object, Exception exception) {
        this.out.println(ConsoleComponentMonitor.format("PicoContainer: invocation failed: {0} on {1}, reason: {2}", new Object[]{method, object, exception.getMessage()}));
        this.delegate.invocationFailed(method, object, exception);
    }

    public void lifecycleInvocationFailed(Method method, Object object, RuntimeException runtimeException) {
        this.out.println(ConsoleComponentMonitor.format("PicoContainer: lifecycle invocation failed: {0} on {1}, reason: {2}", new Object[]{method, object, runtimeException.getMessage()}));
        this.delegate.lifecycleInvocationFailed(method, object, runtimeException);
    }
}

