/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.nonblockingnio;

import csfs.datatransfer.nonblockingnio.GettingFile;
import csfs.datatransfer.nonblockingnio.ImportHandler;
import csfs.datatransfer.nonblockingnio.ImportState;
import java.io.IOException;
import java.nio.ByteBuffer;

public class GettingFileSize
extends ImportState {
    public static final int HEADER_SIZE = 8;
    private ByteBuffer buffer = ByteBuffer.allocate(8);

    public GettingFileSize(ImportHandler handler) {
        this.remainingBytes = 8L;
        this.handler = handler;
    }

    @Override
    public void read() throws IOException {
        long bytesRead = this.handler.getSourceChannel().read(this.buffer);
        this.decRemainingBytes(bytesRead);
    }

    @Override
    protected void decRemainingBytes(long value) throws IOException {
        this.remainingBytes -= value;
        if (this.remainingBytes == 0L) {
            this.buffer.flip();
            long fileSize = this.buffer.getLong();
            this.handler.setFileSize(fileSize);
            this.handler.changeState(new GettingFile(this.handler));
        }
    }
}

