/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public class ImplementationHidingComponentAdapter
extends DecoratingComponentAdapter {
    private final boolean strict;

    public ImplementationHidingComponentAdapter(ComponentAdapter componentAdapter, boolean bl) {
        super(componentAdapter);
        this.strict = bl;
    }

    public Object getComponentInstance(PicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object object = this.getDelegate().getComponentKey();
        Class[] classArray = null;
        if (object instanceof Class && ((Class)this.getDelegate().getComponentKey()).isInterface()) {
            classArray = new Class[]{(Class)this.getDelegate().getComponentKey()};
        } else if (object instanceof Class[]) {
            classArray = (Class[])object;
        } else {
            if (this.strict) {
                throw new PicoIntrospectionException("In strict mode, " + this.getClass().getName() + " only allows components registered with interface keys (java.lang.Class or java.lang.Class[])");
            }
            return this.getDelegate().getComponentInstance(picoContainer);
        }
        Class[] classArray2 = this.verifyInterfacesOnly(classArray);
        return this.createProxy(classArray2, picoContainer, this.getDelegate().getComponentImplementation().getClassLoader());
    }

    private Object createProxy(Class[] classArray, final PicoContainer picoContainer, ClassLoader classLoader) {
        return Proxy.newProxyInstance(classLoader, classArray, new InvocationHandler(){

            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                Object object2 = ImplementationHidingComponentAdapter.this.getDelegate().getComponentInstance(picoContainer);
                ComponentMonitor componentMonitor = ImplementationHidingComponentAdapter.this.currentMonitor();
                try {
                    componentMonitor.invoking(method, object2);
                    long l = System.currentTimeMillis();
                    Object object3 = method.invoke(object2, objectArray);
                    componentMonitor.invoked(method, object2, System.currentTimeMillis() - l);
                    return object3;
                }
                catch (InvocationTargetException invocationTargetException) {
                    componentMonitor.invocationFailed(method, object2, invocationTargetException);
                    throw invocationTargetException.getTargetException();
                }
            }
        });
    }

    private Class[] verifyInterfacesOnly(Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i].isInterface()) continue;
            throw new PicoIntrospectionException("Class keys must be interfaces. " + classArray[i] + " is not an interface.");
        }
        return classArray;
    }
}

