#!/bin/sh

BASE_DIR=$PWD
LUA51_BIN=/usr/bin/lua5.1
GIT_TECENG=https://git.tecgraf.puc-rio.br
GIT_PUTS=$GIT_TECENG/openbus/puts.git
GIT_REPO=$GIT_TECENG/openbus/puts-repository.git
BUILD_DIR=$BASE_DIR/build
BUILD_MODULES="sgad-1.0snapshot"
PUTS_HOME=$BASE_DIR/puts
PUTS_REPO=$BASE_DIR/repository
PUTS_BIN="$LUA51_BIN -epackage.path=[[$PUTS_HOME/lua/?.lua]] $PUTS_HOME/lua/tools/console.lua --config=$BUILD_DIR/puts.conf"
mkdir $BUILD_DIR
echo "BASEDIR = '$BUILD_DIR'"      > $BUILD_DIR/puts.conf
echo "SPEC_SERVERS={'$PUTS_REPO'}" >> $BUILD_DIR/puts.conf

if [ ! -f $PUTS_HOME ]; then
  git clone $GIT_PUTS $PUTS_HOME
else
  cd $PUTS_HOME ; git pull ; cd -
fi

if [ ! -f $PUTS_REPO ]; then
    git clone $GIT_REPO $PUTS_REPO
else
    cd $PUTS_REPO ; git pull ; cd -
fi

$PUTS_BIN --make_manifest $PUTS_REPO

#rm -fr $BUILD_DIR/{install,build,packs}

$PUTS_BIN --compile --verbose --rebuild --update --force \
          --select="$BUILD_MODULES" #--dependencies
