/*
 * Decompiled with CFR 0.152.
 */
package csfs.impl.util;

import csfs.impl.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;

public class Util {
    public static boolean isValid(File f) {
        boolean response;
        try {
            String rootDir = SystemProperties.getProperty("CANONICAL_ROOT_DIR");
            String absolutePath = f.getCanonicalPath();
            response = absolutePath.startsWith(rootDir);
            if (response && absolutePath.indexOf("..") != -1) {
                String relativePath = absolutePath.substring(rootDir.length() + 1);
                File probe = new File(rootDir);
                String allowedPath = probe.getCanonicalPath();
                String[] elements = Util.stringToStringArray(relativePath, "" + Util.getLocalFileSeparator());
                for (int i = 0; i < elements.length && response; ++i) {
                    probe = new File(probe, elements[i]);
                    String currentPath = probe.getCanonicalPath();
                    if (elements[i].equals("..")) {
                        response = currentPath.startsWith(allowedPath);
                        continue;
                    }
                    if (currentPath.startsWith(allowedPath)) continue;
                    allowedPath = currentPath;
                }
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
            response = false;
        }
        return response;
    }

    public static String[] stringToStringArray(String path) {
        return Util.stringToStringArray(path, "/");
    }

    public static String[] stringToStringArray(String path, String tokensChars) {
        StringTokenizer tokenizer = new StringTokenizer(path, tokensChars);
        int tokens = tokenizer.countTokens();
        String[] response = new String[tokens];
        for (int i = 0; i < response.length; ++i) {
            response[i] = tokenizer.nextToken();
        }
        return response;
    }

    public static String stringArrayToString(String[] path) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < path.length; ++i) {
            buf.append(path[i]);
            if (i + 1 >= path.length) continue;
            buf.append('/');
        }
        String filePath = buf.toString();
        return filePath;
    }

    public static String localFileSeparatorToSystemFileSeparator(String path) {
        String response = path;
        char fileSeparator = Util.getLocalFileSeparator();
        if (fileSeparator != '/') {
            response = path.replace(fileSeparator, '/');
        }
        return response;
    }

    public static char getLocalFileSeparator() {
        String fileSeparatorProp = SystemProperties.getProperty("FILE_SEPARATOR");
        char fileSeparator = fileSeparatorProp == null ? File.separatorChar : fileSeparatorProp.charAt(0);
        return fileSeparator;
    }

    public static String systemFileSeparatorToLocalFileSeparator(String path) {
        String response = path;
        char fileSeparator = Util.getLocalFileSeparator();
        if (fileSeparator != '/') {
            response = path.replace('/', fileSeparator);
        }
        return response;
    }

    public static String remoteFileSeparatorToSystemFileSeparator(String path, char remoteFileSeparator) {
        String response = path;
        if (remoteFileSeparator != '/') {
            response = path.replace(remoteFileSeparator, '/');
        }
        return response;
    }

    public static String[] getPathArray(String systemPath, String[] element) {
        String fullPath = systemPath + '/' + Util.stringArrayToString(element);
        return Util.stringToStringArray(fullPath);
    }

    public static String[] getPathArray(String systemPath, String element) {
        String fullPath = systemPath + '/' + element;
        return Util.stringToStringArray(fullPath);
    }

    public static String readStringFromBuffer(ByteBuffer buffer) {
        int limit = buffer.limit();
        StringBuffer response = new StringBuffer();
        for (int position = buffer.position(); position < limit; ++position) {
            byte b = buffer.get();
            if (b == 10) break;
            response.append((char)b);
        }
        return response.toString();
    }

    public static long readLongFromBuffer(ByteBuffer buffer) {
        int limit = buffer.limit();
        long response = 0L;
        for (int position = buffer.position(); position < limit; ++position) {
            byte b = buffer.get();
            if (b == 10) break;
            response = response * 10L + (long)(b - 48);
        }
        return response;
    }
}

