package csdk.v2.api.core;

import java.awt.Window;
import java.nio.charset.Charset;
import java.util.Locale;

/**
 * Interface com o ambiente CSDK.
 */
public interface ICSDKEnvironment {

  /**
   * Requisita o encerramento da execuo da aplicao. Este mtodo deve ser
   * chamado caso a aplicao deseje ser terminada a qualquer hora antes da
   * finalizao pelo prprio ambiente. A aplicao precisa estar ativa para que
   * possa ser finalizada.
   */
  public void finishApplication();

  /**
   * Delega para o ambiente o tratamento de uma exceo.
   *
   * @param error a exceo.
   * @param parent janela que pode ser usada como base para mostrar mensagens de
   *        erro, se necessrio. Aceita {@code null}.
   */
  public void handleException(Exception error, Window parent);

  /**
   * Obtm o locale do ambiente.
   *
   * @return o locale.
   */
  public Locale getLocale();

  /**
   * Obtm o charset do servidor.
   *
   * @return o charset.
   */
  public Charset getServerCharset();

  /**
   * Obtm o charset do ambiente.
   *
   * @return o charset.
   */
  public Charset getCharset();

  /**
   * Obtm um contexto do ambiente a partir da sua interface. O contexto pode
   * no estar disponvel no ambiente e, nesse caso, o mtodo retorna
   * {@code null}.
   *
   * @param <T> interface do contexto.
   *
   * @param contextClass a interface do contexto desejado.
   * @return uma instncia do contexto ou {@code null} caso este contexto
   *         no esteja disponvel no ambiente.
   */
  public <T extends IContext> T getContext(Class<T> contextClass);

}
