package csdk.v2.helper.command;

import java.util.Map;

import csdk.v2.api.command.IAlgorithmTemplate;
import csdk.v2.api.command.IFlowTemplate;
import csdk.v2.api.filesystem.IFile;

/**
 * Essa classe representa os valores dos paramtros do fluxo de algoritmos que
 * podem ser preenchidos previamente. Para cada algoritmo que faz parte do
 * fluxo, pode-se associar um conjunto de valores de parmetros a serem
 * inicialmente preenchidos.
 */
public class FlowTemplate implements IFlowTemplate {
  /** Nome do fluxo de algoritmos */
  private String flowName;

  /** Identificador da verso do fluxo de algoritmos */
  private String flowVersionId;

  /**
   * Arquivo de definio do fluxo, caso este no esteja instalado no servidor.
   */
  private IFile flowDefinitionFile;

  /** Lista de valores dos parmetros dos algoritmos do fluxo */
  private Map<Integer, IAlgorithmTemplate> parametersValuesList;

  /**
   * Construtor.
   * 
   * @param flowName nome do fluxo
   * @param flowVersionId identificador da verso do fluxo de algoritmos
   * @param parametersValuesList lista de valores dos parmetros dos algoritmos
   *        do fluxo
   */
  public FlowTemplate(String flowName, String flowVersionId,
    Map<Integer, IAlgorithmTemplate> parametersValuesList) {
    this.flowName = flowName;
    this.flowVersionId = flowVersionId;
    this.parametersValuesList = parametersValuesList;
  }

  /**
   * Construtor.
   * 
   * @param flowDefinitionFile arquivo de definio do fluxo.
   * @param parametersValuesList lista de valores dos parmetros dos algoritmos
   *        do fluxo
   */
  public FlowTemplate(IFile flowDefinitionFile,
    Map<Integer, IAlgorithmTemplate> parametersValuesList) {
    this.flowDefinitionFile = flowDefinitionFile;
    this.parametersValuesList = parametersValuesList;
  }

  /**
   * Obtm o nome do fluxo de algoritmos.
   * 
   * @return o nome do fluxo de algoritmos
   */
  @Override
  public String getFlowName() {
    return flowName;
  }

  /**
   * Obtm o identificador da verso do fluxo de algoritmos.
   * 
   * @return o identificador da verso do fluxo de algoritmos
   */
  @Override
  public String getFlowVersionId() {
    return flowVersionId;
  }

  /**
   * Obtm uma lista com os valores dos parmetros a serem inicializados no
   * fluxo de algoritmos.
   * 
   * @return uma lista com os valores dos parmetros do fluxo
   */
  @Override
  public Map<Integer, IAlgorithmTemplate> getParametersValuesByNodeId() {
    return parametersValuesList;
  }

  /**
   * Altera a lista com os valores dos parmetros a serem inicializados no fluxo
   * de algoritmos.
   * 
   * @param parametersValuesList lista com os valores dos parmetros do fluxo
   */
  public void setParametersValuesList(
    Map<Integer, IAlgorithmTemplate> parametersValuesList) {
    this.parametersValuesList = parametersValuesList;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public IFile getFlowDefinitionFile() {
    return flowDefinitionFile;
  }

}
