package csdk.v2.helper.command.parameters;

/**
 * Definio de um valor do tipo {@code <T>} de um parmetro .
 * 
 * @param <T> o tipo do valor do parmetro.
 */
public interface IParameterValue<T> {

  /**
   * Obtm o valor do parmetro.
   * 
   * @return o valor.
   */
  public T getValue();

  /**
   * Obtm a representao do valor do parmetro no formato string.
   * 
   * @return a representao do valor em string.
   * 
   * @throws ParameterValueConvertionException caso ocorra algum erro na
   *         converso do valor do parmetro para string.
   */
  public String getValueAsString() throws ParameterValueConvertionException;

}
