/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.helper;

import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.core.ICSDKEnvironment;
import csdk.v2.helper.AbstractCSDKApplication;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public abstract class AbstractCSDKWindowApplication
extends AbstractCSDKApplication {
    private JFrame applicationFrame;
    private final ArrayList<Window> dependentWindows = new ArrayList();
    private WindowCloseListener windowCloseListener;

    public AbstractCSDKWindowApplication(ICSDKEnvironment csdkInterface) {
        super(csdkInterface);
        this.applicationFrame = new JFrame();
        this.applicationFrame.setDefaultCloseOperation(0);
        this.windowCloseListener = new WindowCloseListener();
        this.applicationFrame.addWindowListener(this.windowCloseListener);
    }

    public final void onApplicationStart() throws ApplicationException {
        Runnable runnable = () -> {
            try {
                ImageIcon icon = this.getSmallApplicationIcon();
                if (icon != null) {
                    this.applicationFrame.setIconImage(icon.getImage());
                }
                this.applicationFrame.setTitle(this.getApplicationName());
                this.applicationStarted(this.applicationFrame);
                this.applicationFrame.setVisible(true);
            }
            catch (Exception e) {
                this.handleException(e, this.applicationFrame);
            }
        };
        this.invoke(runnable);
    }

    protected abstract void applicationStarted(JFrame var1) throws ApplicationException;

    protected abstract void applicationEnded() throws ApplicationException;

    @Override
    public final void onApplicationEnd() throws ApplicationException {
        Runnable runnable = () -> {
            try {
                this.applicationEnded();
                this.closeDependentWindows();
            }
            catch (Exception e) {
                this.handleException(e, this.applicationFrame);
            }
            finally {
                if (this.applicationFrame != null) {
                    this.applicationFrame.removeWindowListener(this.windowCloseListener);
                    this.windowCloseListener = null;
                    this.applicationFrame.dispose();
                    this.applicationFrame = null;
                }
                this.disposeContexts();
            }
        };
        this.invoke(runnable);
    }

    public final JFrame getApplicationFrame() {
        return this.applicationFrame;
    }

    public final void addWindow(Window win) {
        this.dependentWindows.add(win);
    }

    public final void removeWindow(Window win) {
        this.dependentWindows.remove(win);
    }

    public final void closeDependentWindows() {
        ArrayList<Window> aux = new ArrayList<Window>();
        aux.addAll(this.dependentWindows);
        for (Window window : aux) {
            window.setVisible(false);
            window.dispose();
        }
        this.dependentWindows.clear();
    }

    private void invoke(Runnable code) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                code.run();
            } else {
                SwingUtilities.invokeAndWait(code);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final class WindowCloseListener
    extends WindowAdapter {
        private WindowCloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent arg) {
            AbstractCSDKWindowApplication.this.finishApplication();
        }
    }
}

