package csdk.v1_0.helper;

import csdk.v1_0.api.core.IContext;

/**
 * Exceo utilizada para sinalizar o uso de contextos que no esto disponveis
 * durante a execuo execuo.
 */
public class ContextNotAvailableException extends RuntimeException {

  /**
   * Construtor.
   * 
   * @param context contexto que no est disponvel.
   */
  public ContextNotAvailableException(Class<? extends IContext> context) {
    super("O contexto " + context.getSimpleName()
      + " no est disponvel nesse ambiente");
  }

}
