package csdk.v1_0.helper.command.parameters;

/**
 * Conversor de valores do tipo tabela.
 */
public class TableValueConverter implements
  ParameterValueConverter<IParameterValue<?>[][]> {

  /**
   * Caractere que define o incio da tabela.
   */
  private static final char START_TABLE_CHAR = '{';

  /**
   * Caractere que define o incio de uma linha.
   */
  private static final char START_ROW_CHAR = '{';

  /**
   * Caractere que separa as colunas.
   */
  private static final char ROW_SEPARATOR_CHAR = ',';

  /**
   * Caractere que separa os elementos de uma linha.
   */
  private static final char ELEMENT_SEPARATOR_CHAR = ',';

  /**
   * Caractere que define o fim da tabela.
   */
  private static final char END_TABLE_CHAR = '}';

  /**
   * Caractere que define o fim de uma linha.
   */
  private static final char END_ROW_CHAR = '}';

  /**
   * {@inheritDoc}
   */
  @Override
  public String getValueAsString(IParameterValue<?>[][] rows)
    throws ParameterValueConvertionException {
    StringBuffer tableAsText = new StringBuffer();

    tableAsText.append(START_TABLE_CHAR);
    for (int i = 0; i < rows.length; i++) {
      tableAsText.append(START_ROW_CHAR);
      for (int j = 0; j < rows[i].length; j++) {
        tableAsText.append(rows[i][j].getValueAsString());
        if (j < rows[i].length - 1) {
          tableAsText.append(ELEMENT_SEPARATOR_CHAR);
        }
      }
      tableAsText.append(END_ROW_CHAR);
      if (i < rows.length - 1) {
        tableAsText.append(ROW_SEPARATOR_CHAR);
      }
    }
    tableAsText.append(END_TABLE_CHAR);

    return tableAsText.toString();
  }

}
