package csdk.v2.runner.application;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import csdk.v2.api.application.IApplicationContext;
import csdk.v2.api.application.manager.IApplicationManagerContext;
import csdk.v2.api.core.IContext;
import csdk.v2.api.filesystem.local.ILocalFileSystemContext;
import csdk.v2.api.user.IUser;
import csdk.v2.api.user.IUserContext;
import csdk.v2.api.user.UserException;
import csdk.v2.extras.context.rest.IRestContext;
import csdk.v2.runner.ApplicationRegistry;
import csdk.v2.runner.CSDKLogger;
import csdk.v2.runner.IContextFactory;
import csdk.v2.runner.application.manager.ApplicationManagerContext;
import csdk.v2.runner.filesystem.local.LocalFileSystemContext;
import csdk.v2.runner.rest.RestContext;
import csdk.v2.runner.user.RunnerUser;
import csdk.v2.runner.user.RunnerUserContext;

/**
 * Fbrica padro de contextos do Runner.
 */
public class DefaultContextFactory implements IContextFactory {

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<Class<? extends IContext>, IContext> createCSDKContexts(
    String instanceId, ApplicationRegistry registry, Properties properties) {
    Map<Class<? extends IContext>, IContext> contexts = new HashMap<>();

    ApplicationContext applicationContext =
      new ApplicationContext(instanceId, registry);
    contexts.put(IApplicationContext.class, applicationContext);

    ApplicationManagerContext managerContext =
      new ApplicationManagerContext(registry.getApplicationId(), instanceId);
    contexts.put(IApplicationManagerContext.class, managerContext);

    LocalFileSystemContext localFileSystemContext =
      new LocalFileSystemContext(registry);
    contexts.put(ILocalFileSystemContext.class, localFileSystemContext);

    RestContext restContext = new RestContext(instanceId, registry);
    contexts.put(IRestContext.class, restContext);

    try {
      RunnerUserContext userContext = createUserContext();
      contexts.put(IUserContext.class, userContext);
    }
    catch (UserException e) {
      CSDKLogger logger = CSDKLogger.getInstance();
      logger.logSevere("Error creating User Context!");
    }
    return contexts;
  }

  /**
   * Cria o contexto de usurios.
   *
   * @return o contexto de usurios.
   * @throws UserException - caso o usurio corrente no esteja definido no mapa
   *         de usurios.
   */
  protected RunnerUserContext createUserContext() throws UserException {
    Map<String, IUser> users = new HashMap<>();
    String currentUserName = System.getProperty("user.name");
    IUser currentUser = new RunnerUser(currentUserName, currentUserName, null,
      false);
    String adminUserName = "admin";
    String[] adminMail = new String[] { "admin@admin.com" };
    IUser adminUser = new RunnerUser(adminUserName, adminUserName, adminMail,
      true);
    users.put(currentUserName, currentUser);
    users.put(adminUserName, adminUser);
    return new RunnerUserContext(users, currentUserName);
  }

}
