package csdk.v2.runner.application.manager;

import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.application.IMessage;
import csdk.v2.api.application.IMessageSender;
import csdk.v2.api.application.manager.IApplicationManagerContext;
import csdk.v2.helper.application.MessageSender;
import csdk.v2.runner.ApplicationManager;
import csdk.v2.runner.application.RunnerApplication;
import csdk.v2.runner.core.AbstractContext;

/**
 * Implementao do contexto de gerncia de aplicaes para o Runner.
 *
 * @author Tecgraf
 */
public class ApplicationManagerContext extends AbstractContext implements
  IApplicationManagerContext {

  /**
   * Id de aplicao.
   */
  private final String applicationId;

  /**
   * Id da instncia.
   */
  private final String instanceId;

  /**
   * Construtor.
   *
   * @param applicationId Id de aplicao.
   * @param instanceId Id da instncia.
   */
  public ApplicationManagerContext(String applicationId, String instanceId) {
    this.applicationId = applicationId;
    this.instanceId = instanceId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String runApplication(String appId) throws ApplicationException {
    final ApplicationManager appManager = ApplicationManager.getInstance();
    RunnerApplication app = appManager.runApplication(appId);
    if (app == null) {
      return null;
    }
    return app.getInstanceId();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isApplicationRunning(String instanceId) {
    final ApplicationManager appManager = ApplicationManager.getInstance();
    return appManager.isApplicationRunning(instanceId);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void killApplication(String instanceId) throws ApplicationException {
    final ApplicationManager appManager = ApplicationManager.getInstance();
    appManager.finishApplication(instanceId);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object sendSyncMessage(String appId,
    IMessage message) throws ApplicationException {
    final ApplicationManager appManager = ApplicationManager.getInstance();
    IMessageSender sender = new MessageSender(applicationId, instanceId);
    return appManager.sendSyncMessage(appId, message, sender);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void sendAsyncMessage(String appId,
    IMessage message) throws ApplicationException {
    final ApplicationManager appManager = ApplicationManager.getInstance();
    IMessageSender sender = new MessageSender(applicationId, instanceId);
    appManager.sendAsyncMessage(appId, message, sender);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void broadcastAsyncMessage(
    IMessage message) throws ApplicationException {
    final ApplicationManager appManager = ApplicationManager.getInstance();
    IMessageSender sender = new MessageSender(applicationId, instanceId);
    appManager.broadcastAsyncMessage(message, sender);
  }
}
