/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.runner.rest;

import csdk.v2.extras.context.rest.IRestContext;
import csdk.v2.extras.context.rest.RestException;
import csdk.v2.runner.ApplicationRegistry;
import csdk.v2.runner.core.AbstractContext;
import csdk.v2.runner.rest.RestController;
import org.glassfish.jersey.server.ResourceConfig;

public class RestContext
extends AbstractContext
implements IRestContext {
    private final String prefix;

    public RestContext(String instanceId, ApplicationRegistry registry) {
        this.prefix = registry.getApplicationId() + "/" + instanceId;
    }

    public void registerResources(ResourceConfig resourceConfig) throws RestException {
        RestController restController = RestController.getInstance();
        if (resourceConfig.getInstances().isEmpty() || !resourceConfig.getClasses().isEmpty()) {
            String error = "Failed to register instances from the provided ResourceConfig as REST resources. Check for classes or packages wrongly registered on ResourceConfig, since only instances are allowed.";
            throw new RestException(error);
        }
        restController.addApplicationResources(this.prefix, resourceConfig);
    }

    public void unregisterResources() {
        RestController restController = RestController.getInstance();
        restController.removeApplicationResources(this.prefix);
    }

    @Override
    protected void contextDeactivated() {
        this.unregisterResources();
    }
}

