package csdk.v2.runner;

import java.util.Map;
import java.util.Properties;

import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.core.IContext;

/**
 * Fbrica de contextos do CSDK.
 */
public interface IContextFactory {

  /**
   * Cria o mapa de contextos do CSDK, que sero disponibilizados para a
   * aplicao, indexados pelas interfaces CSDK que eles implementam.
   * 
   * @param appInstanceId identificador da instncia da aplicao.
   * @param registry o reigstro da aplicao.
   * @param properties propriedades do ambiente.
   * @return o mapa de contextos.
   * 
   * @throws ApplicationException em caso de erro ao criar os contextos.
   */
  public Map<Class<? extends IContext>, IContext> createCSDKContexts(
    String appInstanceId, ApplicationRegistry registry, Properties properties)
    throws ApplicationException;
}
