/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.runner.core;

import csdk.v1_0.api.application.ApplicationException;
import csdk.v1_0.api.application.IApplicationContext;
import csdk.v1_0.api.application.IMessage;
import csdk.v1_0.api.application.IMessageSender;
import csdk.v1_0.api.core.ICSDKEnvironment;
import csdk.v1_0.api.core.IContext;
import csdk.v1_0.helper.application.MessageSender;
import csdk.v1_0.runner.ApplicationManager;
import csdk.v1_0.runner.application.RunnerApplication;
import csdk.v1_0.runner.core.RunnerErrorDialog;
import java.awt.Window;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import tecgraf.javautils.core.lng.LNG;

public class RunnerEnvironment
implements ICSDKEnvironment,
Serializable {
    private final Map<Class<? extends IContext>, IContext> contexts;
    private final String charsetName;

    public RunnerEnvironment(Map<Class<? extends IContext>, IContext> contexts, String charsetName) {
        this.contexts = contexts;
        this.charsetName = charsetName;
    }

    public void finishApplication() {
        IApplicationContext appContext = this.getApplicationContext();
        String instanceId = appContext.getInstanceId();
        ApplicationManager appManager = ApplicationManager.getInstance();
        RunnerApplication app = appManager.getRunningApp(instanceId);
        if (app == null) {
            throw new IllegalStateException("Application " + instanceId + " cannot be finished, it is not active yet or has already been deactivated");
        }
        if (app.finishApplication()) {
            appManager.deactivate(app);
        }
    }

    private IApplicationContext getApplicationContext() {
        IApplicationContext appContext = (IApplicationContext)this.contexts.get(IApplicationContext.class);
        return appContext;
    }

    public void cleanupContexts() {
        for (IContext context : this.contexts.values()) {
            if (!context.isActive()) continue;
            context.onContextDeactivate();
        }
    }

    public String runApplication(String appId) throws ApplicationException {
        ApplicationManager appManager = ApplicationManager.getInstance();
        RunnerApplication app = appManager.runApplication(appId, Charset.forName(this.charsetName));
        if (app == null) {
            return null;
        }
        return app.getInstanceId();
    }

    public boolean sendMessage(String appId, IMessage message) {
        IApplicationContext appContext = this.getApplicationContext();
        String instanceId = appContext.getInstanceId();
        String applicationId = appContext.getApplicationId();
        ApplicationManager appManager = ApplicationManager.getInstance();
        MessageSender sender = new MessageSender(applicationId, instanceId);
        return appManager.sendMessage(appId, message, (IMessageSender)sender);
    }

    public void handleException(Exception error, Window parent) {
        IApplicationContext appContext = this.getApplicationContext();
        String[] additionalInfo = this.createEnvironmentInfo(appContext);
        RunnerErrorDialog dialog = new RunnerErrorDialog(parent, null, error, additionalInfo);
        dialog.setVisible(true);
    }

    private String[] createEnvironmentInfo(IApplicationContext appContext) {
        String lngPrefix = RunnerEnvironment.class.getSimpleName();
        String applicationLabel = LNG.get((String)(lngPrefix + ".application"));
        String versionLabel = LNG.get((String)(lngPrefix + ".version"));
        String applicationName = appContext.getApplicationName();
        String applicationVersion = appContext.getVersion();
        String application = applicationLabel + ": " + applicationName;
        String version = versionLabel + ": " + applicationVersion;
        String[] info = new String[]{application, version};
        return info;
    }

    public <T extends IContext> T getContext(Class<T> contextClass) {
        if (contextClass == null) {
            return null;
        }
        IContext context = this.contexts.get(contextClass);
        if (context != null) {
            try {
                IContext t = (IContext)contextClass.cast(context);
                if (!context.isActive()) {
                    t.onContextActivate();
                }
                return (T)t;
            }
            catch (Exception e) {
                this.handleException(e, null);
            }
        }
        return null;
    }

    public Locale getLocale() {
        ApplicationManager appManager = ApplicationManager.getInstance();
        return appManager.getLocale();
    }

    public Charset getCharset() {
        return Charset.forName(this.charsetName);
    }

    public Charset getServerCharset() {
        return Charset.defaultCharset();
    }
}

