/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.runner.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class RunnerErrorDialog
extends JDialog {
    private static final Color BACKGROUND_COLOR = UIManager.getDefaults().getColor("TextField.inactiveBackground");
    private static final int COLUMNS = 80;
    private static final int MESSAGE_ROWS = 4;
    private static final int STACK_ROWS = 14;
    protected final Throwable error;
    protected final String[] additionalInfo;

    public RunnerErrorDialog(Window owner, String title, Throwable error, String[] additionalInfo) {
        super(owner, title);
        this.error = error;
        this.additionalInfo = additionalInfo;
        this.setDefaultCloseOperation(2);
        this.createComponents();
    }

    private void createComponents() {
        String lngPrefix = RunnerErrorDialog.class.getSimpleName();
        JLabel messageLabel = new JLabel(LNG.get((String)(lngPrefix + ".message")));
        JScrollPane msgScrollPane = this.createMessagePane();
        JLabel stackTraceLabel = new JLabel(LNG.get((String)(lngPrefix + ".stack")));
        JScrollPane stackTraceScroll = this.createStackPane();
        JLabel label = new JLabel(LNG.get((String)(lngPrefix + ".info")));
        JScrollPane scrollPane = this.createInfoPane();
        this.setLayout(new GridBagLayout());
        Insets li = new Insets(5, 6, 0, 10);
        Insets fi = new Insets(3, 10, 5, 10);
        int y = 0;
        this.add((Component)label, new GBC(0, y++).west().insets(li));
        this.add((Component)scrollPane, new GBC(0, y++).both().insets(fi));
        this.add((Component)messageLabel, new GBC(0, y++).west().insets(li));
        this.add((Component)msgScrollPane, new GBC(0, y++).both().insets(fi));
        this.add((Component)stackTraceLabel, new GBC(0, y++).west().insets(li));
        this.add((Component)stackTraceScroll, new GBC(0, y++).both().insets(fi));
        this.pack();
        GUIUtils.centerWindow((Window)this.getOwner(), (Window)this);
    }

    private JScrollPane createInfoPane() {
        int rows = 3;
        if (this.additionalInfo != null && this.additionalInfo.length != 0) {
            rows = this.additionalInfo.length + 1;
        }
        JTextArea additionalInfoTextArea = new JTextArea(rows, 80);
        additionalInfoTextArea.setEditable(false);
        additionalInfoTextArea.setBackground(BACKGROUND_COLOR);
        additionalInfoTextArea.setText(this.createAdditionalInfoText());
        return new JScrollPane(additionalInfoTextArea);
    }

    private JScrollPane createStackPane() {
        JTextArea stackTraceTextArea = new JTextArea(this.getStackTraceText());
        stackTraceTextArea.setColumns(80);
        stackTraceTextArea.setRows(14);
        stackTraceTextArea.setEditable(false);
        stackTraceTextArea.setBackground(BACKGROUND_COLOR);
        return new JScrollPane(stackTraceTextArea);
    }

    private JScrollPane createMessagePane() {
        JTextArea messageTextArea = new JTextArea(this.error.getLocalizedMessage());
        messageTextArea.setColumns(80);
        messageTextArea.setRows(4);
        messageTextArea.setEditable(false);
        messageTextArea.setBackground(BACKGROUND_COLOR);
        return new JScrollPane(messageTextArea);
    }

    private String createAdditionalInfoText() {
        StringBuilder info = new StringBuilder();
        if (this.additionalInfo != null && this.additionalInfo.length > 0) {
            for (int i = 0; i < this.additionalInfo.length; ++i) {
                info.append(this.additionalInfo[i]);
                info.append("\n");
            }
        }
        return info.toString();
    }

    private String getStackTraceText() {
        StringWriter writer = new StringWriter();
        this.error.printStackTrace(new PrintWriter(writer));
        return ((Object)writer).toString();
    }
}

