/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.runner.application;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;

public class ApplicationClassLoader
extends URLClassLoader {
    public ApplicationClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public ApplicationClassLoader(URL[] urls) {
        this(urls, null);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
            if (c == null && (c = this.getParent().loadClass(name)) == null) {
                throw new ClassNotFoundException(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null && this.getParent() != null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            if (url != null) {
                return url.openStream();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> res = this.findResources(name);
        if (res == null && this.getParent() != null) {
            res = this.getParent().getResources(name);
        }
        return res;
    }
}

