/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.runner;

import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

class CSDKLogger {
    private static final Level DEFAULT_LOGGER_LEVEL = Level.SEVERE;
    private final Logger logger = Logger.getLogger("global");
    private static CSDKLogger instance;

    private CSDKLogger() {
        this.setVerbosed(false);
        CSDKLoggerFormatter formatter = new CSDKLoggerFormatter();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(formatter);
        this.logger.addHandler(handler);
        this.logger.setUseParentHandlers(false);
    }

    public static CSDKLogger getInstance() {
        if (instance == null) {
            instance = new CSDKLogger();
        }
        return instance;
    }

    public void setVerbosed(boolean verbosed) {
        Level level = verbosed ? Level.ALL : DEFAULT_LOGGER_LEVEL;
        this.logger.setLevel(level);
    }

    public void log(String text) {
        this.logger.log(Level.INFO, text);
    }

    public void logSevere(String text) {
        this.logger.log(Level.SEVERE, text);
    }

    private final class CSDKLoggerFormatter
    extends Formatter {
        private final Date date = new Date();

        private CSDKLoggerFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder b = new StringBuilder();
            this.date.setTime(record.getMillis());
            b.append(this.date);
            b.append(" [CSDK] ");
            b.append(record.getMessage());
            b.append(System.getProperty("line.separator"));
            return b.toString();
        }
    }
}

