/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.runner.core;

import csdk.v1_0.api.application.ApplicationException;
import csdk.v1_0.api.application.IApplicationContext;
import csdk.v1_0.api.application.IMessage;
import csdk.v1_0.api.application.IMessageSender;
import csdk.v1_0.api.core.ICSDKEnvironment;
import csdk.v1_0.api.core.IContext;
import csdk.v1_0.helper.application.MessageSender;
import csdk.v1_0.runner.ApplicationManager;
import csdk.v1_0.runner.application.RunnerApplication;
import java.awt.Dimension;
import java.awt.Window;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class RunnerEnvironment
implements ICSDKEnvironment {
    private final Map<Class<? extends IContext>, IContext> contexts;

    public RunnerEnvironment(Map<Class<? extends IContext>, IContext> contexts) {
        this.contexts = contexts;
    }

    public void finishApplication() {
        IApplicationContext appContext = this.getApplicationContext();
        String instanceId = appContext.getInstanceId();
        ApplicationManager appManager = ApplicationManager.getInstance();
        RunnerApplication app = appManager.getRunningApp(instanceId);
        if (app == null) {
            throw new IllegalStateException("Application " + instanceId + " cannot be finished, it is not active yet or has already been deactivated");
        }
        if (app.finishApplication()) {
            appManager.deactivate(app);
        }
    }

    private IApplicationContext getApplicationContext() {
        IApplicationContext appContext = (IApplicationContext)this.contexts.get(IApplicationContext.class);
        return appContext;
    }

    public void cleanupContexts() {
        for (IContext context : this.contexts.values()) {
            if (!context.isActive()) continue;
            context.onContextDeactivate();
        }
    }

    public String runApplication(String appId) throws ApplicationException {
        ApplicationManager appManager = ApplicationManager.getInstance();
        RunnerApplication app = appManager.runApplication(appId);
        if (app == null) {
            return null;
        }
        return app.getInstanceId();
    }

    public boolean sendMessage(String appId, IMessage message) {
        IApplicationContext appContext = this.getApplicationContext();
        String instanceId = appContext.getInstanceId();
        String applicationId = appContext.getApplicationId();
        ApplicationManager appManager = ApplicationManager.getInstance();
        MessageSender sender = new MessageSender(applicationId, instanceId);
        return appManager.sendMessage(appId, message, (IMessageSender)sender);
    }

    public void handleException(Exception error, Window parent) {
        IApplicationContext appContext = this.getApplicationContext();
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        error.printStackTrace(printWriter);
        String errorString = ((Object)writer).toString();
        String applicationName = appContext.getApplicationName();
        JTextArea errorArea = new JTextArea();
        errorArea.setText(errorString);
        errorArea.setEditable(false);
        errorArea.setCaretPosition(0);
        JScrollPane panel = new JScrollPane(errorArea);
        panel.setPreferredSize(new Dimension(450, 110));
        panel.setAutoscrolls(true);
        JOptionPane.showMessageDialog(parent, panel, applicationName, 0);
    }

    public <T extends IContext> T getContext(Class<T> contextClass) {
        if (contextClass == null) {
            return null;
        }
        IContext context = this.contexts.get(contextClass);
        if (context != null) {
            try {
                IContext t = (IContext)contextClass.cast(context);
                if (!context.isActive()) {
                    t.onContextActivate();
                }
                return (T)t;
            }
            catch (Exception e) {
                this.handleException(e, null);
            }
        }
        return null;
    }

    public Locale getLocale() {
        ApplicationManager appManager = ApplicationManager.getInstance();
        return appManager.getLocale();
    }

    public Charset getCharset() {
        return Charset.defaultCharset();
    }

    public Charset getServerCharset() {
        return null;
    }
}

