/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.runner.filesystem;

import csdk.v1_0.api.filesystem.IFileLock;
import java.awt.Window;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import tecgraf.javautils.LNG;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.gui.Task;

public class CSDKLocalFileLock
implements IFileLock {
    private final FileLock lock;
    private FileChannel channel;
    private IFileLock.LockStatus status;

    public CSDKLocalFileLock(final File file, final boolean shared, final Window window) throws Exception {
        if (file.isDirectory()) {
            throw new Exception("A directory cannot be locked (" + file.getAbsolutePath() + ")");
        }
        Task<FileLock> task = new Task<FileLock>(){

            protected void performTask() throws Exception {
                FileLock fileLock = CSDKLocalFileLock.this._lock(shared, window, file);
                this.setResult(fileLock);
            }
        };
        String prefix = CSDKLocalFileLock.class.getSimpleName();
        String key = shared ? ".shared.lock.message" : ".exclusive.lock.message";
        String message = LNG.get((String)(prefix + key));
        task.execute(window, null, message);
        this.lock = (FileLock)task.getResult();
        this.setLockStatus();
        if (task.wasCancelled()) {
            this.releaseLock(window);
        }
    }

    public IFileLock.LockStatus getLockStatus() {
        return this.status;
    }

    public void releaseLock(Window window) {
        Task<Void> task = new Task<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void performTask() throws Exception {
                try {
                    CSDKLocalFileLock.this._releaseLock(CSDKLocalFileLock.this.lock);
                }
                finally {
                    FileUtils.close((Closeable)CSDKLocalFileLock.this.channel);
                }
            }
        };
        String prefix = CSDKLocalFileLock.class.getSimpleName();
        String message = LNG.get((String)(prefix + ".release.lock.message"));
        if (task.execute(window, null, message)) {
            this.status = IFileLock.LockStatus.LOCK_RELEASED;
        }
    }

    private FileLock _lock(boolean shared, Window window, File file) throws IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            String mode = shared ? "r" : "rws";
            randomAccessFile = new RandomAccessFile(file, mode);
            this.channel = randomAccessFile.getChannel();
            return this.channel.tryLock(0L, Long.MAX_VALUE, shared);
        }
        catch (Exception e) {
            FileUtils.close(randomAccessFile);
            return null;
        }
    }

    private void _releaseLock(FileLock fileLock) throws IOException {
        if (fileLock != null && fileLock.isValid()) {
            fileLock.release();
        }
    }

    private void setLockStatus() {
        this.status = this.lock != null ? (this.lock.isShared() ? IFileLock.LockStatus.LOCK_SHARED : IFileLock.LockStatus.LOCK_EXCLUSIVE) : IFileLock.LockStatus.LOCK_DENIED;
    }
}

