/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.runner.filesystem;

import csdk.v1_0.api.filesystem.IFileLock;
import csdk.v1_0.runner.CSDKLogger;
import java.awt.Window;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import tecgraf.javautils.LNG;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.gui.Task;

public class CSDKLocalFileLock
implements IFileLock {
    private final FileLock lock;
    private FileChannel channel;

    public CSDKLocalFileLock(final File file, final boolean shared, final Window window) throws Exception {
        if (file.isDirectory()) {
            throw new Exception("A directory cannot be locked (" + file.getAbsolutePath() + ")");
        }
        Task<FileLock> task = new Task<FileLock>(){

            protected void performTask() {
                FileLock fileLock = CSDKLocalFileLock.this._lock(shared, window, file);
                this.setResult(fileLock);
            }
        };
        String prefix = CSDKLocalFileLock.class.getSimpleName();
        String key = shared ? ".shared.lock.message" : ".exclusive.lock.message";
        String message = LNG.get((String)(prefix + key));
        task.execute(window, null, message);
        this.lock = (FileLock)task.getResult();
        if (task.wasCancelled()) {
            this.releaseLock(window);
        }
    }

    public IFileLock.LockStatus getLockStatus() {
        if (this.lock != null) {
            if (this.lock.isValid()) {
                if (this.lock.isShared()) {
                    return IFileLock.LockStatus.LOCK_SHARED;
                }
                return IFileLock.LockStatus.LOCK_EXCLUSIVE;
            }
            return IFileLock.LockStatus.LOCK_RELEASED;
        }
        return IFileLock.LockStatus.LOCK_DENIED;
    }

    public void releaseLock(Window window) {
        Task<Void> task = new Task<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void performTask() throws Exception {
                try {
                    CSDKLocalFileLock.this._releaseLock(CSDKLocalFileLock.this.lock);
                }
                finally {
                    FileUtils.close((Closeable)CSDKLocalFileLock.this.channel);
                }
            }
        };
        String prefix = CSDKLocalFileLock.class.getSimpleName();
        String message = LNG.get((String)(prefix + ".release.lock.message"));
        task.execute(window, null, message);
    }

    private FileLock _lock(boolean shared, Window window, File file) {
        RandomAccessFile randomAccessFile = null;
        try {
            String mode = shared ? "r" : "rws";
            randomAccessFile = new RandomAccessFile(file, mode);
            this.channel = randomAccessFile.getChannel();
            return this.channel.tryLock(0L, Long.MAX_VALUE, shared);
        }
        catch (OverlappingFileLockException e) {
            this.logSevere("Lock for file " + file.getPath() + " already exists in current VM");
            FileUtils.close((Closeable)randomAccessFile);
            return null;
        }
        catch (Exception e) {
            FileUtils.close(randomAccessFile);
            return null;
        }
    }

    private void logSevere(String text) {
        CSDKLogger logger = CSDKLogger.getInstance();
        logger.logSevere(text);
    }

    private void _releaseLock(FileLock fileLock) throws IOException {
        if (fileLock != null && fileLock.isValid()) {
            fileLock.release();
        }
    }
}

