/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.runner;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import javax.swing.ImageIcon;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;

public class ApplicationRegistry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient PropertyResourceBundle bundle = null;
    private final HashMap<String, String> applicationProperties = new HashMap();
    private transient ClassLoader classloader;
    private final String id;
    private String className;
    private boolean isBundleRequired = false;
    private String applicationName;
    private ImageIcon applicationIcon;
    private ImageIcon smallApplicationIcon;
    private String version;
    private String[] fileTypes;
    private String author;
    private String authorEmail;
    private String description;
    private boolean singleton;
    private boolean requiresProject;
    private List<URL> classpath;
    private String iconPath;
    private String smallIconPath;

    public ApplicationRegistry(String id) {
        this.id = id;
    }

    public PropertyResourceBundle loadInternalBundle() {
        if (this.classloader == null) {
            return null;
        }
        if (this.isBundleRequired()) {
            Locale locale = LNG.getLocale();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            String sep = "/";
            StringBuilder pathBuilder = new StringBuilder();
            pathBuilder.append(this.getResourceBaseDir());
            pathBuilder.append(sep);
            pathBuilder.append("resources");
            pathBuilder.append(sep);
            pathBuilder.append(this.getSimpleClassName());
            pathBuilder.append("_");
            pathBuilder.append(language);
            pathBuilder.append("_");
            pathBuilder.append(country);
            pathBuilder.append(".properties");
            String resourcePath = pathBuilder.toString();
            InputStream in = this.classloader.getResourceAsStream(resourcePath);
            if (in == null) {
                String err = "internal bundle not found: " + resourcePath;
                throw new IllegalStateException(err);
            }
            try {
                PropertyResourceBundle err = new PropertyResourceBundle(in);
                return err;
            }
            catch (IOException e) {
                String err = "internal bundle failure error";
                throw new IllegalStateException(err, e);
            }
            finally {
                FileUtils.close((Closeable)in);
            }
        }
        return null;
    }

    private String getResourceBaseDir() {
        String packageName = this.getPackageName();
        return packageName.replace(".", "/");
    }

    public ClassLoader getClassloader() {
        if (this.classloader == null) {
            this.classloader = this.createClassLoader();
        }
        return this.classloader;
    }

    private ClassLoader createClassLoader() {
        List<URL> paths = this.getClasspath();
        URL[] urls = paths == null ? new URL[]{} : paths.toArray(new URL[paths.size()]);
        URLClassLoader loader = new URLClassLoader(urls, this.getClass().getClassLoader());
        return loader;
    }

    public ImageIcon getImageIcon(String[] path) {
        if (this.classloader == null) {
            return null;
        }
        try {
            String sep = "/";
            StringBuilder resPath = new StringBuilder();
            resPath.append(this.getResourceBaseDir());
            resPath.append(sep);
            resPath.append("resources");
            resPath.append(sep);
            resPath.append("images");
            resPath.append(sep);
            for (String pathElement : path) {
                resPath.append(pathElement);
                resPath.append(sep);
            }
            resPath.deleteCharAt(resPath.length() - 1);
            URL res = this.classloader.getResource(resPath.toString());
            return new ImageIcon(res);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getPackageName() {
        int index = this.className.lastIndexOf(".");
        String packageName = index != -1 ? this.className.substring(0, index) : "";
        return packageName;
    }

    private String getSimpleClassName() {
        int index = this.className.lastIndexOf(".");
        String simpleClassName = index != -1 ? this.className.substring(index + 1, this.className.length()) : this.className;
        return simpleClassName;
    }

    public boolean hasString(String key) {
        if (!this.isBundleRequired()) {
            return false;
        }
        if (this.bundle == null) {
            this.bundle = this.loadInternalBundle();
        }
        boolean containsKey = this.bundle.containsKey(key);
        return containsKey;
    }

    public String getString(String key) {
        if (!this.isBundleRequired()) {
            String err = "Not configured for bundles (--app-bundle)!";
            throw new IllegalStateException(err);
        }
        if (this.bundle == null) {
            this.bundle = this.loadInternalBundle();
        }
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key == null ? "<<<null>>>" : "<<<" + key + ">>>";
        }
    }

    public String getString(String key, Object[] args) {
        String pattern = this.getString(key);
        return MessageFormat.format(pattern, args);
    }

    public boolean isPropertyNull(String propName) {
        String tag = this.id + "." + propName;
        if (!this.applicationProperties.containsKey(tag)) {
            return true;
        }
        String value = this.applicationProperties.get(tag);
        return value.trim().isEmpty();
    }

    public String getProperty(String propName) {
        String tag = this.id + "." + propName;
        if (this.isPropertyNull(propName)) {
            String err = "Prop. indefinida [" + tag + "] para apl. " + this.id;
            throw new IllegalStateException(err);
        }
        String value = this.applicationProperties.get(tag);
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return null;
        }
        return value.trim();
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setBundleRequired(boolean requiresBundle) {
        this.isBundleRequired = requiresBundle;
    }

    public void setApplicationName(String name) {
        this.applicationName = name;
    }

    public boolean hasNoProperty() {
        return this.applicationProperties.size() == 0;
    }

    public String getApplicationId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isBundleRequired() {
        return this.isBundleRequired;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public ImageIcon getApplicationIcon() {
        return this.applicationIcon;
    }

    public ImageIcon getSmallApplicationIcon() {
        return this.smallApplicationIcon;
    }

    public void setApplicationIconPath(String iconPath) {
        this.iconPath = iconPath;
        this.applicationIcon = new ImageIcon(iconPath);
    }

    public String getApplicationIconPath() {
        return this.iconPath;
    }

    public String getSmallApplicationIconPath() {
        return this.smallIconPath;
    }

    public void setSmallApplicationIconPath(String iconPath) {
        this.smallIconPath = iconPath;
        this.smallApplicationIcon = new ImageIcon(iconPath);
    }

    protected String getId() {
        return this.id;
    }

    public void setProperty(String key, String value) {
        this.applicationProperties.put(key, value);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        if (this.version == null) {
            return "0.0.0";
        }
        return this.version;
    }

    public void setFileTypes(String[] fileTypes) {
        this.fileTypes = Arrays.copyOf(fileTypes, fileTypes.length);
    }

    public String[] getFileTypes() {
        if (this.fileTypes != null) {
            return Arrays.copyOf(this.fileTypes, this.fileTypes.length);
        }
        return new String[0];
    }

    public String getAuthor() {
        return this.author;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public String getApplicationDescription() {
        return this.description;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    protected void setApplicationDescription(String description) {
        this.description = description;
    }

    protected void setAuthor(String author) {
        this.author = author;
    }

    protected void setAuthorEmail(String email) {
        this.authorEmail = email;
    }

    protected void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean requiresProject() {
        return this.requiresProject;
    }

    public void setRequiresProject(boolean requiresProject) {
        this.requiresProject = requiresProject;
    }

    public List<URL> getClasspath() {
        return this.classpath;
    }

    public void setClasspath(List<URL> paths) {
        this.classpath = paths;
    }
}

