/*
 * Decompiled with CFR 0.152.
 */
package brickbreaker;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.image.Image;
import javafx.util.Duration;

public final class Config {
    public static final Duration ANIMATION_TIME = Duration.millis((double)40.0);
    public static final int MAX_LIVES = 9;
    public static final int FIELD_BRICK_IN_ROW = 15;
    public static final String IMAGE_DIR = "images/desktop/";
    public static final int WINDOW_BORDER = 3;
    public static final int TITLE_BAR_HEIGHT = 19;
    public static final int SCREEN_WIDTH = 960;
    public static final int SCREEN_HEIGHT = 720;
    public static final int INFO_TEXT_SPACE = 10;
    public static final int BRICK_WIDTH = 48;
    public static final int BRICK_HEIGHT = 24;
    public static final int SHADOW_WIDTH = 10;
    public static final int SHADOW_HEIGHT = 16;
    public static final double BALL_MIN_SPEED = 6.0;
    public static final double BALL_MAX_SPEED = 24.0;
    public static final double BALL_MIN_COORD_SPEED = 2.0;
    public static final double BALL_SPEED_INC = 0.5;
    public static final int BAT_Y = 680;
    public static final int BAT_SPEED = 8;
    public static final int BONUS_SPEED = 3;
    public static final int FIELD_WIDTH = 720;
    public static final int FIELD_HEIGHT = 720;
    public static final int FIELD_Y = 0;
    private static final String[] BRICKS_IMAGES = new String[]{"blue.png", "broken1.png", "broken2.png", "brown.png", "cyan.png", "green.png", "grey.png", "magenta.png", "orange.png", "red.png", "violet.png", "white.png", "yellow.png"};
    private static ObservableList<Image> bricksImages = FXCollections.observableArrayList();
    private static final String[] BONUSES_IMAGES = new String[]{"ballslow.png", "ballfast.png", "catch.png", "batgrow.png", "batreduce.png", "ballgrow.png", "ballreduce.png", "strike.png", "extralife.png"};
    private static ObservableList<Image> bonusesImages = FXCollections.observableArrayList();
    public static final int IMAGE_BACKGROUND = 0;
    public static final int IMAGE_BAT_LEFT = 1;
    public static final int IMAGE_BAT_CENTER = 2;
    public static final int IMAGE_BAT_RIGHT = 3;
    public static final int IMAGE_BALL_0 = 4;
    public static final int IMAGE_BALL_1 = 5;
    public static final int IMAGE_BALL_2 = 6;
    public static final int IMAGE_BALL_3 = 7;
    public static final int IMAGE_BALL_4 = 8;
    public static final int IMAGE_BALL_5 = 9;
    public static final int IMAGE_LOGO = 10;
    public static final int IMAGE_SPLASH_BRICK = 11;
    public static final int IMAGE_SPLASH_BRICKSHADOW = 12;
    public static final int IMAGE_SPLASH_BREAKER = 13;
    public static final int IMAGE_SPLASH_BREAKERSHADOW = 14;
    public static final int IMAGE_SPLASH_PRESSANYKEY = 15;
    public static final int IMAGE_SPLASH_PRESSANYKEYSHADOW = 16;
    public static final int IMAGE_SPLASH_STRIKE = 17;
    public static final int IMAGE_SPLASH_STRIKESHADOW = 18;
    public static final int IMAGE_SPLASH_SUN = 19;
    public static final int IMAGE_READY = 20;
    public static final int IMAGE_GAMEOVER = 21;
    private static final String[] IMAGES_NAMES = new String[]{"background.png", "bat/left.png", "bat/center.png", "bat/right.png", "ball/ball0.png", "ball/ball1.png", "ball/ball2.png", "ball/ball3.png", "ball/ball4.png", "ball/ball5.png", "logo.png", "splash/brick.png", "splash/brickshadow.png", "splash/breaker.png", "splash/breakershadow.png", "splash/pressanykey.png", "splash/pressanykeyshadow.png", "splash/strike.png", "splash/strikeshadow.png", "splash/sun.png", "ready.png", "gameover.png"};
    private static ObservableList<Image> images = FXCollections.observableArrayList();

    public static ObservableList<Image> getBricksImages() {
        return bricksImages;
    }

    public static ObservableList<Image> getBonusesImages() {
        return bonusesImages;
    }

    public static ObservableList<Image> getImages() {
        return images;
    }

    public static void initialize() {
        Image image;
        String url;
        for (String imageName : IMAGES_NAMES) {
            Image image2 = new Image(Config.class.getResourceAsStream(IMAGE_DIR + imageName));
            if (image2.isError()) {
                System.out.println("Image " + imageName + " not found");
            }
            images.add((Object)image2);
        }
        for (String imageName : BRICKS_IMAGES) {
            url = "images/desktop/brick/" + imageName;
            image = new Image(Config.class.getResourceAsStream(url));
            if (image.isError()) {
                System.out.println("Image " + url + " not found");
            }
            bricksImages.add((Object)image);
        }
        for (String imageName : BONUSES_IMAGES) {
            url = "images/desktop/bonus/" + imageName;
            image = new Image(Config.class.getResourceAsStream(url));
            if (image.isError()) {
                System.out.println("Image " + url + " not found");
            }
            bonusesImages.add((Object)image);
        }
    }

    private Config() {
    }
}

