/*
 * Decompiled with CFR 0.152.
 */
package brickbreaker;

import brickbreaker.Level;
import brickbreaker.LevelData;
import brickbreaker.Splash;
import javafx.scene.Group;

public class MainController {
    private Group root;
    private Splash splash;
    private Level level;
    private int lifeCount;
    private int score;
    public static final int SPLASH = 0;
    private int state = 0;

    public MainController(Group root) {
        this.root = root;
    }

    public int getState() {
        return this.state;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public int getLifeCount() {
        return this.lifeCount;
    }

    public void increaseLives() {
        this.lifeCount = Math.min(this.lifeCount + 1, 9);
    }

    public void decreaseLives() {
        --this.lifeCount;
    }

    public void startGame() {
        this.lifeCount = 3;
        this.score = 0;
        this.changeState(1);
    }

    public void changeState(int newState) {
        this.state = newState;
        if (this.splash != null) {
            this.splash.stop();
        }
        if (this.level != null) {
            this.level.stop();
        }
        if (this.state < 1 || this.state > LevelData.getLevelsCount()) {
            this.root.getChildren().remove((Object)this.level);
            this.level = null;
            this.splash = new Splash(this);
            this.root.getChildren().add((Object)this.splash);
            this.splash.start();
        } else {
            this.root.getChildren().remove((Object)this.splash);
            this.splash = null;
            this.level = new Level(this.state, this);
            this.root.getChildren().add((Object)this.level);
            this.level.start();
        }
    }
}

