package hello;

import java.awt.Dimension;
import java.net.URL;
import java.util.ResourceBundle;

import javax.swing.JFrame;

import csdk.v2.fx.helper.AbstractJFXApplication;
import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.core.ICSDKEnvironment;
import javafx.scene.Parent;
import tecgraf.javautils.gui.SwingThreadDispatcher;

/**
 * Aplicao Hello World JavaFX, que faz uso de um arquivo fxml para montar
 * GUI.<br>
 * Ateno: Como esta aplicao possui um boto fechar, precisamos usar
 * SwingThreadDispatcher para contornar bug do Java. @see
 * <code> {@link ControleAplicacao#fechar()}</code>
 *
 * @author Tecgraf/PUC-Rio
 */
public class FXHello extends AbstractJFXApplication {

  /**
   * Construtor.
   *
   * @param csdkInterface interface padro para o ambiente CSDK.
   */
  public FXHello(ICSDKEnvironment csdkInterface) {
    super(csdkInterface);
    // SwingThreadDispatcher necessrio para contornar bug no Windows...
    // contexto na thread vem null causando exceo ao fechar aplicao
    // se estivermos usando SwingUtilities.invokeLater
    SwingThreadDispatcher.init();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Parent getParentNode() throws Exception {
    ResourceBundle resourceBundle = ResourceBundle.getBundle(
      "hello.resources.FXHello", getLocale());
    URL url = getClass().getResource("view/ola-mundo.fxml");
    return loadParentNode(url, resourceBundle, new ControleAplicacao(this));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void applicationStarted(JFrame mainFrame)
    throws ApplicationException {
    mainFrame.setSize(new Dimension(350, 110));
    mainFrame.setLocationRelativeTo(null); // centralizar
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void applicationEnded() throws ApplicationException {
    // vazio
  }

}
