/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.fx.helper;

import csdk.v2.api.core.ICSDKEnvironment;
import csdk.v2.helper.AbstractCSDKWindowApplication;
import java.awt.Component;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.stage.Modality;
import javafx.stage.Window;

public abstract class AbstractJFXApplication
extends AbstractCSDKWindowApplication {
    private JFXPanel jfxPanel = new JFXPanel();

    public AbstractJFXApplication(ICSDKEnvironment csdkInterface) {
        super(csdkInterface);
        Platform.setImplicitExit((boolean)false);
        this.initFX();
        this.getApplicationFrame().add((Component)this.jfxPanel);
    }

    public void initFX() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Parent root = AbstractJFXApplication.this.getParentNode();
                    Scene scene = new Scene(root);
                    AbstractJFXApplication.this.configStyle(scene);
                    AbstractJFXApplication.this.jfxPanel.setScene(scene);
                }
                catch (Exception e) {
                    AbstractJFXApplication.this.handleException(e, AbstractJFXApplication.this.getApplicationFrame());
                    e.printStackTrace();
                }
            }
        });
    }

    protected abstract Parent getParentNode() throws Exception;

    protected final Parent loadParentNode(URL fxml, ResourceBundle bundle, Object controller) throws Exception {
        FXMLLoader loader = new FXMLLoader(fxml, bundle);
        if (controller != null) {
            loader.setController(controller);
        }
        Parent root = (Parent)loader.load();
        return root;
    }

    protected void configStyle(Scene scene) {
    }

    @Override
    public void finishApplication() {
        if (Platform.isFxApplicationThread()) {
            throw new RuntimeException("C\u00f3digo deve ser executado na EDT, por\u00e9m est\u00e1 rodando na Thread FX!");
        }
        this.jfxPanel.setScene(null);
        super.finishApplication();
    }

    protected Window getWindowStage() {
        Scene scene = this.jfxPanel.getScene();
        if (scene == null) {
            return null;
        }
        return scene.getWindow();
    }

    protected void showModalAlert(Alert.AlertType type, String header, String message) {
        Alert alert = new Alert(type);
        alert.initModality(Modality.WINDOW_MODAL);
        alert.initOwner(this.getWindowStage());
        alert.setTitle(this.getApplicationName());
        alert.setHeaderText(header);
        alert.setContentText(message);
        alert.setResizable(true);
        alert.show();
    }
}

