package snakegame.algorithm.euclidean;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import snakegame.algorithm.IMoveAlgorithm;
import snakegame.algorithm.util.DeltaDouble;
import snakegame.algorithm.util.Util;
import snakegame.map.Direction;

/**
 * Algoritmo Guloso Euclidiano.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class EuclideanAlgorithm implements IMoveAlgorithm {

  /** {@inheritDoc} */
  @Override
  public Direction whereShouldIGo(List<Point> snake, Direction direction,
    Point food, int rows, int columns) {

    Point right = Util.lookahead(snake, Direction.RIGHT, rows, columns);
    Point left = Util.lookahead(snake, Direction.LEFT, rows, columns);
    Point down = Util.lookahead(snake, Direction.DOWN, rows, columns);
    Point up = Util.lookahead(snake, Direction.UP, rows, columns);

    Double rightDistance = distance(right, food);
    Double leftDistance = distance(left, food);
    Double downDistance = distance(down, food);
    Double upDistance = distance(up, food);

    Double minDistance = Math.min(rightDistance, leftDistance);
    minDistance = Math.min(minDistance, upDistance);
    minDistance = Math.min(minDistance, downDistance);

    List<DeltaDouble> candidates = new ArrayList<DeltaDouble>();
    candidates.add(new DeltaDouble(rightDistance, Direction.RIGHT));
    candidates.add(new DeltaDouble(leftDistance, Direction.LEFT));
    candidates.add(new DeltaDouble(upDistance, Direction.UP));
    candidates.add(new DeltaDouble(downDistance, Direction.DOWN));

    Collections.sort(candidates);

    return candidates.get(0).getDirection();
  }

  /**
   * Calcula a distncia entre 2 pontos.
   * 
   * @param a origem.
   * @param b destino.
   * @return distncia.
   */
  private Double distance(Point a, Point b) {
    if (a == null || b == null) {
      return Double.MAX_VALUE;
    }

    return Math.pow(b.x - a.x, 2) + Math.pow(b.y - a.y, 2);
  }

}
