package snakegame.algorithm.util;

import snakegame.map.Direction;

/**
 * Distncia em {@link Double}.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class DeltaDouble implements Comparable<DeltaDouble> {

  /** Distncia. */
  private Double distance;

  /** Direo. */
  private Direction direction;

  /**
   * Candidato.
   * 
   * @param distance distncia.
   * @param direction direo.
   */
  public DeltaDouble(Double distance, Direction direction) {
    if (distance == null) {
      throw new IllegalArgumentException("distance no pode ser nulo.");
    }
    if (direction == null) {
      throw new IllegalArgumentException("direction no pode ser nulo.");
    }
    this.distance = distance;
    this.direction = direction;
  }

  /**
   * Distncia.
   * 
   * @return distncia.
   */
  public Double getDistance() {
    return distance;
  }

  /**
   * Direo.
   * 
   * @return direo.
   */
  public Direction getDirection() {
    return direction;
  }

  /** {@inheritDoc} */
  @Override
  public int compareTo(DeltaDouble other) {
    if (distance < other.distance) {
      return -1;
    }
    else if (distance > other.distance) {
      return 1;
    }
    return 0;
  }
}
