/*
 * Decompiled with CFR 0.152.
 */
package snakegame.map;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.swing.table.DefaultTableModel;
import snakegame.algorithm.IMoveAlgorithm;
import snakegame.exception.GameOverException;
import snakegame.exception.VictoryException;
import snakegame.map.Cell;
import snakegame.map.Direction;
import snakegame.session.MapSize;

public class SnakeTableModel
extends DefaultTableModel {
    private final Cell[][] map;
    private List<Point> snake;
    private Point food;
    private Direction direction;
    private final IMoveAlgorithm algorithm;

    public SnakeTableModel(MapSize mapSize, boolean fill, IMoveAlgorithm algorithm) {
        super(mapSize.size, mapSize.size);
        this.algorithm = algorithm;
        this.map = new Cell[this.getRowCount()][this.getColumnCount()];
        for (int i = 0; i < this.map.length; ++i) {
            for (int j = 0; j < this.map[i].length; ++j) {
                this.map[i][j] = Cell.EMPTY;
            }
        }
        if (fill) {
            int middle = this.getRowCount() / 2;
            this.snake = new ArrayList<Point>();
            this.snake.add(new Point(middle, middle));
            this.snake.add(new Point(middle - 1, middle));
            this.snake.add(new Point(middle - 2, middle));
            for (Point point : this.snake) {
                this.map[point.x][point.y] = Cell.SNAKE;
            }
            this.direction = Direction.DOWN;
            this.food = this.findEmptySpace();
            this.map[this.food.x][this.food.y] = Cell.FOOD;
        }
    }

    public SnakeTableModel(MapSize size) {
        this(size, false, null);
    }

    public void setDirection(Direction direction) {
        if (direction == null) {
            return;
        }
        if (this.direction == Direction.DOWN && direction == Direction.UP) {
            return;
        }
        if (this.direction == Direction.UP && direction == Direction.DOWN) {
            return;
        }
        if (this.direction == Direction.LEFT && direction == Direction.RIGHT) {
            return;
        }
        if (this.direction == Direction.RIGHT && direction == Direction.LEFT) {
            return;
        }
        this.direction = direction;
    }

    public void move() throws GameOverException, VictoryException {
        this.executeAlgorithm();
        Point nextPoint = this.nextPoint();
        Cell nextCell = this.map[nextPoint.x][nextPoint.y];
        switch (nextCell) {
            case SNAKE: {
                throw new GameOverException("Suic\u00eddio.");
            }
            case EMPTY: {
                this.snake.add(0, nextPoint);
                this.map[nextPoint.x][nextPoint.y] = Cell.SNAKE;
                Point point = this.snake.remove(this.snake.size() - 1);
                this.map[point.x][point.y] = Cell.EMPTY;
                break;
            }
            case FOOD: {
                this.snake.add(0, nextPoint);
                this.map[nextPoint.x][nextPoint.y] = Cell.SNAKE;
                if (this.snake.size() == this.map.length * this.map.length) {
                    throw new VictoryException("Parab\u00e9ns!");
                }
                this.food = this.findEmptySpace();
                this.map[this.food.x][this.food.y] = Cell.FOOD;
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.map[row][column];
    }

    private Point nextPoint() throws GameOverException {
        int x = this.snake.get((int)0).x;
        int y = this.snake.get((int)0).y;
        switch (this.direction) {
            case UP: {
                --x;
                break;
            }
            case DOWN: {
                ++x;
                break;
            }
            case LEFT: {
                --y;
                break;
            }
            case RIGHT: {
                ++y;
            }
        }
        if (x < 0 || x == this.map.length || y < 0 || y == this.map.length) {
            throw new GameOverException("Limite do mapa excedido.");
        }
        return new Point(x, y);
    }

    private Point findEmptySpace() {
        int y;
        int x;
        Random random = new Random(System.currentTimeMillis());
        while (this.map[x = random.nextInt(this.map.length)][y = random.nextInt(this.map.length)] != Cell.EMPTY) {
        }
        return new Point(x, y);
    }

    private void executeAlgorithm() {
        if (this.algorithm == null) {
            return;
        }
        List<Point> points = Collections.unmodifiableList(this.snake);
        int rows = this.getRowCount();
        int columns = this.getColumnCount();
        this.setDirection(this.algorithm.whereShouldIGo(points, this.direction, this.food, rows, columns));
    }
}

