/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.helper.command.parameters;

import csdk.v2.helper.command.parameters.ParameterValueConverter;
import csdk.v2.helper.command.parameters.ParameterValueConvertionException;
import java.util.List;

public class ListValueConverter<T>
implements ParameterValueConverter<List<T>> {
    private static final char START_LINE_CHAR = '{';
    private static final char ELEMENT_SEPARATOR_CHAR = ',';
    private static final char END_LINE_CHAR = '}';
    private final ParameterValueConverter<T> singleValueConverter;

    public ListValueConverter(ParameterValueConverter<T> singleValueConverter) {
        this.singleValueConverter = singleValueConverter;
    }

    @Override
    public String getValueAsString(List<T> values) throws ParameterValueConvertionException {
        if (values == null || values.size() == 0) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        String separator = "";
        for (T value : values) {
            buffer.append(separator);
            buffer.append(this.singleValueConverter.getValueAsString(value));
            separator = Character.toString(',');
        }
        buffer.append('}');
        return buffer.toString();
    }
}

