/*
 * Decompiled with CFR 0.152.
 */
package snakegame;

import csdk.v1_0.api.application.ApplicationException;
import csdk.v1_0.api.core.ICSDKEnvironment;
import csdk.v1_0.helper.AbstractCSDKWindowApplication;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import snakegame.Actions;
import snakegame.MoveTask;
import snakegame.algorithm.IMoveAlgorithm;
import snakegame.map.Direction;
import snakegame.map.SnakeTableModel;
import snakegame.map.renderer.MapRenderer;
import snakegame.session.Level;
import snakegame.session.MapSize;
import snakegame.session.Session;
import snakegame.session.listener.MapSizeChangedListener;
import snakegame.session.listener.ModeChangedListener;
import tecgraf.javautils.gui.GBC;

public class SnakeGame
extends AbstractCSDKWindowApplication {
    public SnakeGame(ICSDKEnvironment csdkInterface) {
        super(csdkInterface);
    }

    protected void applicationStarted(JFrame frame) throws ApplicationException {
        frame.setLayout(new GridBagLayout());
        Session session = new Session(MapSize.SMALL, Level.NORMAL);
        Actions actions = new Actions(this, session);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu(session, actions));
        menuBar.add(this.createOptionsMenu(session, actions));
        menuBar.add(this.createHelpMenu(actions));
        frame.setJMenuBar(menuBar);
        MapSize mapSize = session.getMapSize();
        JTable table = new JTable(new SnakeTableModel(mapSize)){

            @Override
            public boolean isCellSelected(int row, int column) {
                return false;
            }
        };
        table.setDefaultRenderer(Object.class, new MapRenderer());
        frame.add((Component)table, new GBC(0, 0));
        frame.setPreferredSize(session.getMapSize().dimension);
        frame.setResizable(false);
        frame.pack();
        this.addKeyListeners(table);
        this.addSessionListeners(session, actions, table);
    }

    protected void applicationEnded() throws ApplicationException {
    }

    private JMenu createFileMenu(Session session, Actions actions) {
        JMenu file = new JMenu(this.getString("menu.file", new Object[0]));
        file.add((Action)((Object)actions.playAction));
        file.addSeparator();
        file.add((Action)((Object)actions.greedyAction));
        file.add((Action)((Object)actions.manhattanAction));
        file.addSeparator();
        file.add((Action)actions.exitAction);
        return file;
    }

    private JMenu createOptionsMenu(Session session, Actions actions) {
        JRadioButtonMenuItem smallSize = new JRadioButtonMenuItem((Action)((Object)actions.smallAction));
        JRadioButtonMenuItem largeSize = new JRadioButtonMenuItem((Action)((Object)actions.largeAction));
        ButtonGroup group = new ButtonGroup();
        group.add(smallSize);
        group.add(largeSize);
        JRadioButtonMenuItem easy = new JRadioButtonMenuItem((Action)((Object)actions.easyAction));
        JRadioButtonMenuItem normal = new JRadioButtonMenuItem((Action)((Object)actions.normalAction));
        JRadioButtonMenuItem hard = new JRadioButtonMenuItem((Action)((Object)actions.hardAction));
        group = new ButtonGroup();
        group.add(easy);
        group.add(normal);
        group.add(hard);
        JMenu options = new JMenu(this.getString("menu.options", new Object[0]));
        options.add(smallSize);
        options.add(largeSize);
        options.addSeparator();
        options.add(easy);
        options.add(normal);
        options.add(hard);
        smallSize.setSelected(session.getMapSize() == MapSize.SMALL);
        largeSize.setSelected(session.getMapSize() == MapSize.LARGE);
        easy.setSelected(session.getLevel() == Level.EASY);
        normal.setSelected(session.getLevel() == Level.NORMAL);
        hard.setSelected(session.getLevel() == Level.HARD);
        return options;
    }

    private JMenu createHelpMenu(Actions actions) {
        JMenu help = new JMenu(this.getString("menu.help", new Object[0]));
        help.add((Action)actions.aboutAction);
        return help;
    }

    private void addKeyListeners(final JTable table) {
        JFrame frame = this.getApplicationFrame();
        JRootPane rootPane = frame.getRootPane();
        rootPane.getInputMap().put(KeyStroke.getKeyStroke("UP"), "UP");
        rootPane.getActionMap().put("UP", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnakeTableModel model = (SnakeTableModel)table.getModel();
                model.setDirection(Direction.UP);
            }
        });
        rootPane.getInputMap().put(KeyStroke.getKeyStroke("DOWN"), "DOWN");
        rootPane.getActionMap().put("DOWN", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnakeTableModel model = (SnakeTableModel)table.getModel();
                model.setDirection(Direction.DOWN);
            }
        });
        rootPane.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "LEFT");
        rootPane.getActionMap().put("LEFT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnakeTableModel model = (SnakeTableModel)table.getModel();
                model.setDirection(Direction.LEFT);
            }
        });
        rootPane.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "RIGHT");
        rootPane.getActionMap().put("RIGHT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnakeTableModel model = (SnakeTableModel)table.getModel();
                model.setDirection(Direction.RIGHT);
            }
        });
    }

    private void addSessionListeners(final Session session, final Actions actions, final JTable table) {
        session.addMapSizeChangedListener(new MapSizeChangedListener(){

            @Override
            public void perform(MapSize mapSize) {
                SnakeTableModel model = new SnakeTableModel(mapSize);
                table.setModel(model);
                JFrame frame = SnakeGame.this.getApplicationFrame();
                frame.setPreferredSize(mapSize.dimension);
                frame.validate();
                frame.repaint();
                frame.pack();
            }
        });
        session.addModeChangedListener(new ModeChangedListener(){

            @Override
            public void modeOn(IMoveAlgorithm algorithm) {
                MapSize mapSize = session.getMapSize();
                Level level = session.getLevel();
                SnakeTableModel model = new SnakeTableModel(mapSize, true, algorithm);
                table.setModel(model);
                actions.playAction.setEnabled(false);
                actions.greedyAction.setEnabled(false);
                actions.manhattanAction.setEnabled(false);
                actions.smallAction.setEnabled(false);
                actions.largeAction.setEnabled(false);
                actions.easyAction.setEnabled(false);
                actions.normalAction.setEnabled(false);
                actions.hardAction.setEnabled(false);
                Timer timer = new Timer();
                JFrame frame = SnakeGame.this.getApplicationFrame();
                MoveTask task = new MoveTask(session, timer, model, frame);
                timer.schedule((TimerTask)task, 0L, (long)level.step);
            }

            @Override
            public void modeOff() {
                actions.playAction.setEnabled(true);
                actions.greedyAction.setEnabled(true);
                actions.manhattanAction.setEnabled(true);
                actions.smallAction.setEnabled(true);
                actions.largeAction.setEnabled(true);
                actions.easyAction.setEnabled(true);
                actions.normalAction.setEnabled(true);
                actions.hardAction.setEnabled(true);
            }
        });
    }
}

