/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.colorbutton;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import tecgraf.javautils.gui.colorbutton.ColorButtonChoiceListener;

public class ColorButton
extends JButton {
    private final List<ColorButtonChoiceListener> listeners = new ArrayList<ColorButtonChoiceListener>();

    private final void initAttributes() {
        this.setOpaque(true);
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color oldColor = ColorButton.this.getBackground();
                Color newColor = JColorChooser.showDialog(ColorButton.this, "", oldColor);
                if (newColor == null) {
                    newColor = oldColor;
                }
                ColorButton.this.setBackground(newColor);
                for (int i = 0; i < ColorButton.this.listeners.size(); ++i) {
                    ColorButtonChoiceListener lst = (ColorButtonChoiceListener)ColorButton.this.listeners.get(i);
                    if (lst == null) continue;
                    lst.colorChosen(ColorButton.this, newColor);
                }
            }
        });
    }

    public final Color getColor() {
        return this.getBackground();
    }

    public final void setColor(Color color) {
        this.setBackground(color);
    }

    public final void addColorButtonChoiceListener(ColorButtonChoiceListener listener) {
        this.listeners.add(listener);
    }

    public ColorButton() {
        this((Color)null);
    }

    public ColorButton(Color color) {
        this.setText(" ");
        this.initAttributes();
        this.setColor(color);
    }
}

