/*
 * Decompiled with CFR 0.152.
 */
package snakegame;

import csdk.v1_0.helper.application.AbstractApplication;
import csdk.v1_0.helper.application.ApplicationAboutAction;
import csdk.v1_0.helper.application.ApplicationExitAction;
import java.awt.Window;
import snakegame.SnakeGame;
import snakegame.action.ChangeDifficultAction;
import snakegame.action.ChangeMapSizeAction;
import snakegame.action.PlayAction;
import snakegame.algorithm.euclidean.EuclideanAlgorithm;
import snakegame.algorithm.manhattan.ManhattanDistanceAlgorithm;
import snakegame.session.Level;
import snakegame.session.MapSize;
import snakegame.session.Session;

class Actions {
    final PlayAction playAction;
    final PlayAction greedyAction;
    final PlayAction manhattanAction;
    final ChangeMapSizeAction smallAction;
    final ChangeMapSizeAction largeAction;
    final ChangeDifficultAction easyAction;
    final ChangeDifficultAction normalAction;
    final ChangeDifficultAction hardAction;
    final ApplicationExitAction exitAction;
    final ApplicationAboutAction aboutAction;

    Actions(SnakeGame application, Session session) {
        if (application == null) {
            throw new IllegalArgumentException("application n\u00e3o pode ser nulo.");
        }
        if (session == null) {
            throw new IllegalArgumentException("session n\u00e3o pode ser nulo.");
        }
        this.playAction = new PlayAction(application, session, null);
        this.greedyAction = new PlayAction(application, session, new EuclideanAlgorithm());
        this.manhattanAction = new PlayAction(application, session, new ManhattanDistanceAlgorithm());
        this.smallAction = new ChangeMapSizeAction(application, session, MapSize.SMALL);
        this.largeAction = new ChangeMapSizeAction(application, session, MapSize.LARGE);
        this.easyAction = new ChangeDifficultAction(application, session, Level.EASY);
        this.normalAction = new ChangeDifficultAction(application, session, Level.NORMAL);
        this.hardAction = new ChangeDifficultAction(application, session, Level.HARD);
        this.exitAction = new ApplicationExitAction((AbstractApplication)application);
        this.aboutAction = new ApplicationAboutAction((AbstractApplication)application, (Window)application.getApplicationFrame());
    }
}

