/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.runner.core;

import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.application.IApplicationContext;
import csdk.v2.api.application.IMessage;
import csdk.v2.api.core.ICSDKEnvironment;
import csdk.v2.api.core.IContext;
import csdk.v2.helper.application.MessageSender;
import csdk.v2.runner.ApplicationManager;
import csdk.v2.runner.Runner;
import csdk.v2.runner.application.RunnerApplication;
import csdk.v2.runner.core.RunnerErrorDialog;
import java.awt.Window;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;

public class RunnerEnvironment
implements ICSDKEnvironment,
Serializable {
    private final Map<Class<? extends IContext>, IContext> contexts;
    private final Charset charset;

    public RunnerEnvironment(Map<Class<? extends IContext>, IContext> contexts, Charset charsetName) {
        this.contexts = contexts;
        this.charset = charsetName;
    }

    @Override
    public void finishApplication() {
        IApplicationContext appContext = this.getApplicationContext();
        String instanceId = appContext.getInstanceId();
        ApplicationManager appManager = ApplicationManager.getInstance();
        RunnerApplication app = appManager.getRunningApp(instanceId);
        if (app == null) {
            String pattern = "Application {0} cannot be finished, it is not active yet or has already been deactivated";
            String message = MessageFormat.format(pattern, instanceId);
            throw new IllegalStateException(message);
        }
        if (app.finishApplication()) {
            appManager.deactivate(app);
        }
    }

    private IApplicationContext getApplicationContext() {
        IApplicationContext appContext = (IApplicationContext)this.contexts.get(IApplicationContext.class);
        return appContext;
    }

    public void cleanupContexts() {
        for (IContext context : this.contexts.values()) {
            if (!context.isActive()) continue;
            context.onContextDeactivate();
        }
    }

    @Override
    public String runApplication(String appId) throws ApplicationException {
        ApplicationManager appManager = ApplicationManager.getInstance();
        RunnerApplication app = appManager.runApplication(appId, this.charset);
        if (app == null) {
            return null;
        }
        return app.getInstanceId();
    }

    @Override
    public Object sendSyncMessage(String appId, IMessage message) throws ApplicationException {
        IApplicationContext appContext = this.getApplicationContext();
        String instanceId = appContext.getInstanceId();
        String applicationId = appContext.getApplicationId();
        ApplicationManager appManager = ApplicationManager.getInstance();
        MessageSender sender = new MessageSender(applicationId, instanceId);
        return appManager.sendSyncMessage(appId, message, sender);
    }

    @Override
    public void sendAsyncMessage(String appId, IMessage message) throws ApplicationException {
        IApplicationContext appContext = this.getApplicationContext();
        String instanceId = appContext.getInstanceId();
        String applicationId = appContext.getApplicationId();
        ApplicationManager appManager = ApplicationManager.getInstance();
        MessageSender sender = new MessageSender(applicationId, instanceId);
        appManager.sendAsyncMessage(appId, message, sender);
    }

    @Override
    public void broadcastAsyncMessage(IMessage message) throws ApplicationException {
        IApplicationContext appContext = this.getApplicationContext();
        String instanceId = appContext.getInstanceId();
        String applicationId = appContext.getApplicationId();
        ApplicationManager appManager = ApplicationManager.getInstance();
        MessageSender sender = new MessageSender(applicationId, instanceId);
        appManager.broadcastAsyncMessage(message, sender);
    }

    @Override
    public void handleException(Exception error, Window parent) {
        IApplicationContext appContext = this.getApplicationContext();
        String[] additionalInfo = this.createEnvironmentInfo(appContext);
        RunnerErrorDialog dialog = new RunnerErrorDialog(parent, null, error, additionalInfo);
        dialog.setVisible(true);
    }

    private String[] createEnvironmentInfo(IApplicationContext appContext) {
        String applicationName = appContext.getApplicationName();
        String applicationVersion = appContext.getVersion();
        String application = "Application: " + applicationName;
        String version = "Version: " + applicationVersion;
        String[] info = new String[]{application, version};
        return info;
    }

    @Override
    public <T extends IContext> T getContext(Class<T> contextClass) {
        if (contextClass == null) {
            return null;
        }
        IContext context = this.contexts.get(contextClass);
        if (context != null) {
            try {
                IContext t = (IContext)contextClass.cast(context);
                if (!context.isActive()) {
                    t.onContextActivate();
                }
                return (T)t;
            }
            catch (Exception e) {
                this.handleException(e, null);
            }
        }
        return null;
    }

    @Override
    public Locale getLocale() {
        return Runner.getLocale();
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public Charset getServerCharset() {
        return Charset.defaultCharset();
    }
}

