/*
 * Decompiled with CFR 0.152.
 */
package teste;

import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.application.IApplication;
import csdk.v2.api.application.IApplicationContext;
import csdk.v2.api.application.IMessage;
import csdk.v2.api.application.IMessageSender;
import csdk.v2.api.application.manager.IApplicationManagerContext;
import csdk.v2.api.core.ICSDKEnvironment;
import csdk.v2.helper.application.Message;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Teste
implements IApplication {
    private static final String LABEL_PROPERTY = "label";
    private final ICSDKEnvironment csdkInterface;
    private final IApplicationContext appContext;
    private final IApplicationManagerContext appManagerContext;
    private final JFrame mainFrame;

    public Teste(final ICSDKEnvironment csdkInterface) {
        this.csdkInterface = csdkInterface;
        this.appContext = (IApplicationContext)csdkInterface.getContext(IApplicationContext.class);
        this.appManagerContext = (IApplicationManagerContext)csdkInterface.getContext(IApplicationManagerContext.class);
        this.mainFrame = new JFrame();
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                csdkInterface.finishApplication();
            }
        });
    }

    public boolean canEndApplication() {
        String instanceId = this.appContext.getInstanceId();
        System.out.println("[" + instanceId + "] canEndApplication");
        return true;
    }

    public Object onSyncMessageReceived(IMessage message, IMessageSender sender) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(message.getType());
        buffer.append(": ");
        buffer.append(message.getValue());
        buffer.append("\n from: ");
        buffer.append(sender.getApplicationInstanceId());
        buffer.append(" [");
        buffer.append(sender.getApplicationType());
        buffer.append("]");
        JOptionPane.showMessageDialog(this.mainFrame, buffer.toString());
        return null;
    }

    public void onAsyncMessageReceived(IMessage message, IMessageSender sender) {
    }

    public void onApplicationEnd() throws ApplicationException {
        String instanceId = this.appContext.getInstanceId();
        System.out.println("[" + instanceId + "] onApplicationEnd");
        this.mainFrame.dispose();
    }

    public void onApplicationStart() throws ApplicationException {
        String instanceId = this.appContext.getInstanceId();
        System.out.println("[" + instanceId + "] onApplicationStart");
        this.initUI();
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
    }

    private void initUI() {
        String label = this.appContext.isPropertyNull(LABEL_PROPERTY) ? "ID" : this.appContext.getProperty(LABEL_PROPERTY);
        JButton button = new JButton(label + " [" + this.appContext.getInstanceId() + "]");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    String appId = Teste.this.appContext.getApplicationId();
                    String instanceId = Teste.this.appManagerContext.runApplication(appId);
                    Teste.this.appManagerContext.sendSyncMessage(instanceId, (IMessage)new Message("target", (Object)instanceId));
                }
                catch (ApplicationException e) {
                    Teste.this.csdkInterface.handleException((Exception)((Object)e), (Window)Teste.this.mainFrame);
                }
            }
        });
        JPanel panel = new JPanel();
        panel.add(button);
        this.mainFrame.add(panel);
    }
}

