/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.runner.filesystem;

import csdk.v1_0.api.filesystem.IFileLock;
import csdk.v1_0.runner.CSDKLogger;
import csdk.v1_0.runner.filesystem.FileUtils;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.text.MessageFormat;

public class CSDKLocalFileLock
implements IFileLock {
    private final FileLock lock;
    private FileChannel channel;

    public CSDKLocalFileLock(File file, boolean shared, Window window) throws Exception {
        if (file.isDirectory()) {
            String pattern = "A directory cannot be locked ({0})";
            String message = MessageFormat.format(pattern, file.getAbsolutePath());
            throw new Exception(message);
        }
        this.lock = this.lock(shared, window, file);
    }

    @Override
    public IFileLock.LockStatus getLockStatus() {
        if (this.lock != null) {
            if (this.lock.isValid()) {
                if (this.lock.isShared()) {
                    return IFileLock.LockStatus.LOCK_SHARED;
                }
                return IFileLock.LockStatus.LOCK_EXCLUSIVE;
            }
            return IFileLock.LockStatus.LOCK_RELEASED;
        }
        return IFileLock.LockStatus.LOCK_DENIED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLock(Window window) {
        try {
            if (this.lock != null && this.lock.isValid()) {
                this.lock.release();
            }
        }
        catch (IOException e) {
            CSDKLogger logger = CSDKLogger.getInstance();
            logger.logSevere("Lock release failed", new Object[0]);
        }
        finally {
            FileUtils.close(this.channel);
        }
    }

    private FileLock lock(boolean shared, Window window, File file) {
        RandomAccessFile randomAccessFile = null;
        try {
            String mode = shared ? "r" : "rws";
            randomAccessFile = new RandomAccessFile(file, mode);
            this.channel = randomAccessFile.getChannel();
            return this.channel.tryLock(0L, Long.MAX_VALUE, shared);
        }
        catch (OverlappingFileLockException e) {
            CSDKLogger logger = CSDKLogger.getInstance();
            String message = "Lock for file {0} already exists in current VM.";
            logger.logSevere(message, file.getPath());
            FileUtils.close(randomAccessFile);
            return null;
        }
        catch (Exception e) {
            FileUtils.close(randomAccessFile);
            return null;
        }
    }
}

