package testealgo;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextArea;

import csdk.v1_0.api.command.ICommandInfo;

/**
 * Painel que lista todas as propriedades de um comando.
 */
public class CommandReportFrame extends JFrame {

  /**
   * Construtor.
   * 
   * @param info informao do estado do comando.
   */
  public CommandReportFrame(ICommandInfo info) {
    setDefaultCloseOperation(DISPOSE_ON_CLOSE);
    JTextArea area = new JTextArea();
    area.setLineWrap(true);
    area.setWrapStyleWord(true);
    area.setEditable(false);
    area.setFont(new Font(Font.MONOSPACED, Font.PLAIN, 12));
    String lineSeparator = "\n";
    StringBuffer buffer = new StringBuffer();
    buffer.append("** Command Info **");
    buffer.append(lineSeparator);
    buffer.append("command id: ");
    buffer.append(info.getCommandId());
    buffer.append(lineSeparator);
    buffer.append("project id: ");
    buffer.append(info.getProjectId());
    buffer.append(lineSeparator);
    buffer.append("description: ");
    buffer.append(info.getDescription());
    buffer.append(lineSeparator);
    buffer.append("execution host: ");
    buffer.append(info.getExecutionHost());
    buffer.append(lineSeparator);
    buffer.append("finalization type: ");
    buffer.append(info.getFinalizationType());
    buffer.append(lineSeparator);
    buffer.append("exit code: ");
    buffer.append(info.getExitCode());
    buffer.append(lineSeparator);
    Integer guiltyNodeId = info.getGuiltyNodeId();
    if (guiltyNodeId != null) {
      buffer.append("guilty node id: ");
      buffer.append(guiltyNodeId);
      buffer.append(lineSeparator);
    }
    Long startTime = info.getStartTime();
    if (startTime != null) {
      buffer.append("start time: ");
      buffer.append(new Date(startTime));
      buffer.append(lineSeparator);
    }
    Long endTime = info.getEndTime();
    if (endTime != null) {
      buffer.append("end time: ");
      buffer.append(new Date(endTime));
      buffer.append(lineSeparator);
    }
    Integer cpuTime = info.getCPUTimeSec();
    if (cpuTime != null) {
      buffer.append("cpu time: ");
      buffer.append(cpuTime);
      buffer.append(" segundos");
      buffer.append(lineSeparator);
    }
    Integer elapsedTime = info.getElapsedTimeSec();
    if (elapsedTime != null) {
      buffer.append("elapsedTime time: ");
      buffer.append(elapsedTime);
      buffer.append(" segundos");
      buffer.append(lineSeparator);
    }
    Integer userTime = info.getUserTimeSec();
    if (userTime != null) {
      buffer.append("elapsedTime time: ");
      buffer.append(userTime);
      buffer.append(" segundos");
      buffer.append(lineSeparator);
    }
    area.setText(buffer.toString());
    area.setColumns(50);
    area.setMinimumSize(area.getPreferredSize());
    add(area, BorderLayout.NORTH);
    JButton okButton = new JButton("ok");
    okButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        dispose();
      }
    });
    add(okButton, BorderLayout.SOUTH);
    pack();
  }
}
