/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.runner.application;

import csdk.v2.api.application.IApplicationContext;
import csdk.v2.api.core.IContext;
import csdk.v2.api.filesystem.local.ILocalFileSystemContext;
import csdk.v2.api.user.IUser;
import csdk.v2.api.user.IUserContext;
import csdk.v2.api.user.UserException;
import csdk.v2.runner.ApplicationRegistry;
import csdk.v2.runner.CSDKLogger;
import csdk.v2.runner.IContextFactory;
import csdk.v2.runner.application.ApplicationContext;
import csdk.v2.runner.filesystem.local.LocalFileSystemContext;
import csdk.v2.runner.user.RunnerUser;
import csdk.v2.runner.user.RunnerUserContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DefaultContextFactory
implements IContextFactory {
    @Override
    public Map<Class<? extends IContext>, IContext> createCSDKContexts(String instanceId, ApplicationRegistry registry, Properties properties) {
        HashMap<Class<? extends IContext>, IContext> contexts = new HashMap<Class<? extends IContext>, IContext>();
        contexts.put(IApplicationContext.class, new ApplicationContext(instanceId, registry));
        contexts.put(ILocalFileSystemContext.class, new LocalFileSystemContext(registry));
        try {
            RunnerUserContext userContext = this.createUserContext();
            contexts.put(IUserContext.class, userContext);
        }
        catch (UserException e) {
            CSDKLogger logger = CSDKLogger.getInstance();
            logger.logSevere("Error creating User Context!", new Object[0]);
        }
        return contexts;
    }

    protected RunnerUserContext createUserContext() throws UserException {
        HashMap<String, IUser> users = new HashMap<String, IUser>();
        String currentUserName = System.getProperty("user.name");
        RunnerUser currentUser = new RunnerUser(currentUserName, currentUserName, null, false);
        String adminUserName = "admin";
        String[] adminMail = new String[]{"admin@admin.com"};
        RunnerUser adminUser = new RunnerUser(adminUserName, adminUserName, adminMail, true);
        users.put(currentUserName, currentUser);
        users.put(adminUserName, adminUser);
        return new RunnerUserContext(users, currentUserName);
    }
}

