/*
 * Decompiled with CFR 0.152.
 */
package testefs;

import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.application.IApplication;
import csdk.v2.api.application.IApplicationContext;
import csdk.v2.api.application.IMessage;
import csdk.v2.api.application.IMessageSender;
import csdk.v2.api.application.manager.IApplicationManagerContext;
import csdk.v2.api.core.ICSDKEnvironment;
import csdk.v2.api.filesystem.FileSelectionType;
import csdk.v2.api.filesystem.IFile;
import csdk.v2.api.filesystem.IFileLock;
import csdk.v2.api.filesystem.local.ILocalFileSystemContext;
import csdk.v2.api.filesystem.local.LocalFileSystemException;
import csdk.v2.helper.application.Message;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class TesteFS
implements IApplication {
    private final ICSDKEnvironment csdkInterface;
    private final ILocalFileSystemContext localFileSystemContext;
    private final IApplicationManagerContext appManagerContext;
    private final IApplicationContext appContext;
    private final Collection<IFileLock> locks;
    private final JFrame mainFrame;

    public TesteFS(final ICSDKEnvironment csdkInterface) {
        this.csdkInterface = csdkInterface;
        this.appContext = (IApplicationContext)csdkInterface.getContext(IApplicationContext.class);
        this.localFileSystemContext = (ILocalFileSystemContext)csdkInterface.getContext(ILocalFileSystemContext.class);
        this.appManagerContext = (IApplicationManagerContext)csdkInterface.getContext(IApplicationManagerContext.class);
        this.locks = new ArrayList<IFileLock>();
        this.mainFrame = new JFrame();
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                csdkInterface.finishApplication();
            }
        });
        this.initUI();
    }

    public boolean canEndApplication() {
        int result = JOptionPane.showConfirmDialog(this.mainFrame, this.appContext.getString("confirm.message", new Object[0]), this.appContext.getApplicationName(), 0);
        return result == 0;
    }

    public void onAsyncMessageReceived(IMessage message, IMessageSender sender) {
    }

    public Object onSyncMessageReceived(IMessage message, IMessageSender sender) {
        return null;
    }

    public void onApplicationEnd() throws ApplicationException {
        this.mainFrame.dispose();
        for (IFileLock lock : this.locks) {
            lock.releaseLock((Window)this.mainFrame);
        }
    }

    private void initUI() {
        String openLabelName = this.appContext.getString("open.label", new Object[0]);
        final JLabel openLabel = new JLabel(openLabelName);
        String openButtonName = this.appContext.getString("open.button", new Object[0]);
        JButton openButton = new JButton(openButtonName);
        openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IFile file = TesteFS.this.openFile(FileSelectionType.FILES_ONLY);
                if (file != null) {
                    openLabel.setText(file.getStringPath());
                    try {
                        IFileLock sharedLock = file.acquireSharedLock((Window)TesteFS.this.mainFrame);
                        TesteFS.this.locks.add(sharedLock);
                        if (sharedLock.getLockStatus() == IFileLock.LockStatus.LOCK_SHARED || sharedLock.getLockStatus() == IFileLock.LockStatus.LOCK_EXCLUSIVE) {
                            TesteFS.this.openFileInTextViewer(file);
                        } else {
                            String lockMessage = TesteFS.this.appContext.getString("lock.message", new Object[0]);
                            JOptionPane.showMessageDialog(TesteFS.this.mainFrame, lockMessage);
                        }
                    }
                    catch (Exception e) {
                        TesteFS.this.csdkInterface.handleException(e, (Window)TesteFS.this.mainFrame);
                    }
                }
            }
        });
        openButton.setEnabled(this.localFileSystemContext != null);
        String openMultipleLabelName = this.appContext.getString("open.multiple.label", new Object[0]);
        final JLabel openMultipleLabel = new JLabel(openMultipleLabelName);
        String openMultipleButtonName = this.appContext.getString("open.multiple.button", new Object[0]);
        JButton openMultipleButton = new JButton(openMultipleButtonName);
        openMultipleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IFile[] files = TesteFS.this.openMultipleFiles(FileSelectionType.FILES_ONLY);
                StringBuilder builder = new StringBuilder();
                if (files != null) {
                    for (IFile file : files) {
                        builder.append(file.getStringPath());
                        builder.append(" ");
                        try {
                            IFileLock sharedLock = file.acquireSharedLock((Window)TesteFS.this.mainFrame);
                            TesteFS.this.locks.add(sharedLock);
                            if (sharedLock.getLockStatus() == IFileLock.LockStatus.LOCK_SHARED || sharedLock.getLockStatus() == IFileLock.LockStatus.LOCK_EXCLUSIVE) {
                                TesteFS.this.openFileInTextViewer(file);
                                continue;
                            }
                            String lockMessage = TesteFS.this.appContext.getString("lock.message", new Object[0]);
                            JOptionPane.showMessageDialog(TesteFS.this.mainFrame, lockMessage);
                        }
                        catch (Exception e) {
                            TesteFS.this.csdkInterface.handleException(e, (Window)TesteFS.this.mainFrame);
                        }
                    }
                }
                openMultipleLabel.setText(builder.toString());
            }
        });
        openMultipleButton.setEnabled(this.localFileSystemContext != null);
        String openDirLabelName = this.appContext.getString("open.dir.label", new Object[0]);
        final JLabel openDirLabel = new JLabel(openDirLabelName);
        String openDirButtonName = this.appContext.getString("open.dir.button", new Object[0]);
        JButton openDirButton = new JButton(openDirButtonName);
        openDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IFile file = TesteFS.this.openFile(FileSelectionType.DIRECTORIES_ONLY);
                if (file != null) {
                    openDirLabel.setText(file.getStringPath());
                }
            }
        });
        openDirButton.setEnabled(this.localFileSystemContext != null);
        String openMultipleDirLabelName = this.appContext.getString("open.multiple.dir.label", new Object[0]);
        final JLabel openMultipleDirLabel = new JLabel(openMultipleDirLabelName);
        String openMultipleDirButtonName = this.appContext.getString("open.multiple.dir.button", new Object[0]);
        JButton openMultipleDirButton = new JButton(openMultipleDirButtonName);
        openMultipleDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IFile[] files = TesteFS.this.openMultipleFiles(FileSelectionType.DIRECTORIES_ONLY);
                StringBuilder builder = new StringBuilder();
                if (files != null) {
                    for (IFile file : files) {
                        builder.append(file.getStringPath());
                        builder.append(" ");
                    }
                }
                openMultipleDirLabel.setText(builder.toString());
            }
        });
        openMultipleDirButton.setEnabled(this.localFileSystemContext != null);
        String saveLabelName = this.appContext.getString("save.label", new Object[0]);
        final JLabel saveLabel = new JLabel(saveLabelName);
        String saveButtonName = this.appContext.getString("save.button", new Object[0]);
        JButton saveButton = new JButton(saveButtonName);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                IFile file = TesteFS.this.saveFile();
                if (file != null) {
                    saveLabel.setText(file.getStringPath());
                    try {
                        IFileLock exclusiveLock = file.acquireExclusiveLock((Window)TesteFS.this.mainFrame);
                        TesteFS.this.locks.add(exclusiveLock);
                        if (exclusiveLock.getLockStatus() == IFileLock.LockStatus.LOCK_EXCLUSIVE) {
                            TesteFS.this.openFileInTextViewer(file);
                        } else {
                            String lockMessage = TesteFS.this.appContext.getString("lock.message", new Object[0]);
                            JOptionPane.showMessageDialog(TesteFS.this.mainFrame, lockMessage);
                        }
                    }
                    catch (Exception e) {
                        TesteFS.this.csdkInterface.handleException(e, (Window)TesteFS.this.mainFrame);
                    }
                }
            }
        });
        saveButton.setEnabled(this.localFileSystemContext != null);
        JPanel panel = new JPanel();
        panel.add(openLabel);
        panel.add(openButton);
        panel.add(openMultipleLabel);
        panel.add(openMultipleButton);
        panel.add(openDirLabel);
        panel.add(openDirButton);
        panel.add(openMultipleDirLabel);
        panel.add(openMultipleDirButton);
        panel.add(saveLabel);
        panel.add(saveButton);
        this.mainFrame.add(panel);
    }

    public void onApplicationStart() throws ApplicationException {
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
    }

    private void openFileInTextViewer(IFile file) {
        try {
            String textViewerId = this.appManagerContext.runApplication("textviewer");
            Message message = new Message("file", (Object)file);
            this.appManagerContext.sendSyncMessage(textViewerId, (IMessage)message);
        }
        catch (ApplicationException e) {
            this.csdkInterface.handleException((Exception)((Object)e), (Window)this.mainFrame);
        }
    }

    private IFile openFile(FileSelectionType selectionType) {
        try {
            String[] fileTypes = this.appContext.getApplicationFileTypes();
            return this.localFileSystemContext.browseLocalFileInOpenMode(fileTypes, false, null, selectionType, (Window)this.mainFrame);
        }
        catch (LocalFileSystemException e) {
            this.csdkInterface.handleException((Exception)((Object)e), (Window)this.mainFrame);
            return null;
        }
    }

    private IFile[] openMultipleFiles(FileSelectionType selectionType) {
        try {
            String[] fileTypes = this.appContext.getApplicationFileTypes();
            return this.localFileSystemContext.browseMultipleLocalFilesInOpenMode(fileTypes, false, null, selectionType, (Window)this.mainFrame);
        }
        catch (LocalFileSystemException e) {
            this.csdkInterface.handleException((Exception)((Object)e), (Window)this.mainFrame);
            return null;
        }
    }

    private IFile saveFile() {
        try {
            String[] fileTypes = this.appContext.getApplicationFileTypes();
            return this.localFileSystemContext.browseLocalFileInSaveMode(fileTypes, false, "teste.txt", null, (Window)this.mainFrame);
        }
        catch (LocalFileSystemException e) {
            this.csdkInterface.handleException((Exception)((Object)e), (Window)this.mainFrame);
            return null;
        }
    }
}

