/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.rest.helper;

import com.fasterxml.jackson.databind.ObjectMapper;
import csdk.v2.rest.helper.exception.JSONException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONMap
extends HashMap<String, Object> {
    private static ObjectMapper objectMapper = new ObjectMapper();

    public JSONMap(Map<String, Object> map) {
        this.putAll(map);
    }

    public JSONMap(String jsondata) throws JSONException {
        try {
            HashMap map = objectMapper.readValue(jsondata, HashMap.class);
            this.putAll(map);
        }
        catch (IOException e) {
            throw new JSONException("Error parsing JSON", e);
        }
    }

    private String missingFieldMessage(String field) {
        String fmt = "Required message field %s not found";
        String msg = String.format("Required message field %s not found", field);
        return msg;
    }

    public Double asDouble(String field, boolean optional) throws JSONException {
        Object object = this.get(field);
        if (object == null) {
            if (!optional) {
                throw new JSONException(this.missingFieldMessage(field));
            }
            return null;
        }
        Double d = null;
        if (object instanceof Double) {
            d = (Double)object;
        } else if (object instanceof Integer) {
            d = new Double(((Integer)object).intValue());
        } else if (object instanceof String) {
            d = Double.parseDouble((String)object);
        } else if (!optional) {
            String fmt = "Cannot convert field %s to double (value = %s)";
            String msg = String.format("Cannot convert field %s to double (value = %s)", field, object.toString());
            throw new JSONException(msg);
        }
        return d;
    }

    public Integer asInteger(String field, boolean optional) throws JSONException {
        Object object = this.get(field);
        if (object == null) {
            if (!optional) {
                throw new JSONException(this.missingFieldMessage(field));
            }
            return null;
        }
        Integer i = null;
        if (object instanceof Integer) {
            i = (Integer)object;
        } else if (object instanceof String) {
            i = Integer.parseInt((String)object);
        } else if (!optional) {
            String fmt = "Cannot convert field %s to integer (value = %s)";
            String msg = String.format("Cannot convert field %s to integer (value = %s)", field, object.toString());
            throw new JSONException(msg);
        }
        return i;
    }

    public double[] asDoubleArray(String field, boolean optional) throws JSONException {
        Object object = this.get(field);
        if (object == null) {
            if (!optional) {
                throw new JSONException(this.missingFieldMessage(field));
            }
            return null;
        }
        double[] da = null;
        if (object instanceof double[]) {
            da = (double[])object;
        } else if (object instanceof int[]) {
            int[] ia = (int[])object;
            da = new double[ia.length];
            for (int i = 0; i < ia.length; ++i) {
                da[i] = ia[i];
            }
        } else if (object instanceof List) {
            List list = (List)object;
            da = new double[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object value = list.get(i);
                try {
                    da[i] = Double.parseDouble(value.toString());
                    continue;
                }
                catch (NumberFormatException e) {
                    String fmt = "Field %s is an array but contains non-numeric value: %s";
                    String msg = String.format("Field %s is an array but contains non-numeric value: %s", field, value);
                    throw new JSONException(msg);
                }
            }
        } else if (!optional) {
            String fmt = "Cannot convert field %s to double array (value = %s)";
            String msg = String.format("Cannot convert field %s to double array (value = %s)", field, object.toString());
            throw new JSONException(msg);
        }
        return da;
    }

    public String asString(String field, boolean optional) throws JSONException {
        Object object = this.get(field);
        if (object == null) {
            if (!optional) {
                throw new JSONException(this.missingFieldMessage(field));
            }
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (!optional) {
            String fmt = "Cannot recognize field %s as string (value = %s)";
            String msg = String.format("Cannot recognize field %s as string (value = %s)", field, object.toString());
            throw new JSONException(msg);
        }
        return null;
    }

    public JSONMap asJSONMap(String field, boolean optional) throws JSONException {
        Object object = this.get(field);
        if (object == null) {
            if (!optional) {
                throw new JSONException(this.missingFieldMessage(field));
            }
            return null;
        }
        if (object instanceof Map) {
            return new JSONMap((Map)object);
        }
        if (!optional) {
            String fmt = "Cannot recognize field %s as map (value = %s)";
            String msg = String.format("Cannot recognize field %s as map (value = %s)", field, object.toString());
            throw new JSONException(msg);
        }
        return null;
    }

    public List<?> asList(String field, boolean optional) throws JSONException {
        Object object = this.get(field);
        if (object == null) {
            if (!optional) {
                throw new JSONException(this.missingFieldMessage(field));
            }
            return null;
        }
        if (object instanceof List) {
            return (List)object;
        }
        if (!optional) {
            String fmt = "Cannot recognize field %s as list (value = %s)";
            String msg = String.format("Cannot recognize field %s as list (value = %s)", field, object.toString());
            throw new JSONException(msg);
        }
        return null;
    }
}

