/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.rest.helper;

import csdk.v2.helper.application.AbstractApplication;
import csdk.v2.helper.application.Message;
import csdk.v2.helper.application.MessageSender;
import javax.ws.rs.core.Response;

public class ApplicationRestResource<A extends AbstractApplication> {
    private static final String MESSAGE_SENDER_ID = "ApplicationRestClient";
    private final A application;

    public ApplicationRestResource(A application) {
        this.application = application;
    }

    public A getApplication() {
        return this.application;
    }

    public Response handleSyncMessage(String type, Object param) {
        Message msg = new Message(type, param);
        MessageSender sender = new MessageSender(MESSAGE_SENDER_ID, MESSAGE_SENDER_ID);
        try {
            Object response = ((AbstractApplication)this.application).onSyncMessageReceived(msg, sender);
            return Response.ok().entity(response).build();
        }
        catch (Throwable ex) {
            return Response.serverError().entity(ex.getLocalizedMessage()).build();
        }
    }

    public Response handleAsyncMessage(String type, Object param) {
        Message msg = new Message(type, param);
        MessageSender sender = new MessageSender(MESSAGE_SENDER_ID, MESSAGE_SENDER_ID);
        try {
            ((AbstractApplication)this.application).onAsyncMessageReceived(msg, sender);
            return Response.ok().entity("").build();
        }
        catch (Throwable ex) {
            return Response.serverError().entity(ex.getLocalizedMessage()).build();
        }
    }
}

