/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.panel;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import tecgraf.javautils.gui.GUIResources;
import tecgraf.javautils.gui.panel.ExpandablePanel;

public class ExpandablePanelGroup {
    public static final String EXPAND_ALL_ACTION_ID = "groupExpandAll";
    public static final String COLLAPSE_ALL_ACTION_ID = "groupCollapseAll";
    private final Set<ExpandablePanel> panels = new LinkedHashSet<ExpandablePanel>();
    private ActionListener listener;

    public ExpandablePanelGroup add(ExpandablePanel ... panels) {
        for (ExpandablePanel section : panels) {
            this.panels.add(section);
        }
        return this;
    }

    public boolean remove(ExpandablePanel panel) {
        return this.panels.remove(panel);
    }

    public void expandAll() {
        this.expandAll(true);
    }

    public void collapseAll() {
        this.expandAll(false);
    }

    private void expandAll(boolean expand) {
        HashSet<Container> parents = new HashSet<Container>();
        boolean anyChange = false;
        for (ExpandablePanel section : this.panels) {
            if (!section.setExpanded(expand, false, true)) continue;
            section.revalidate();
            parents.add(section.getParent());
            anyChange = true;
        }
        if (anyChange) {
            if (this.listener != null) {
                this.listener.actionPerformed(new ActionEvent(this, (int)System.currentTimeMillis(), expand ? EXPAND_ALL_ACTION_ID : COLLAPSE_ALL_ACTION_ID));
            }
            for (Container parent : parents) {
                parent.repaint();
            }
        }
    }

    public ActionListener setListener(ActionListener newListener) {
        ActionListener oldListener = this.listener;
        this.listener = newListener;
        return oldListener;
    }

    public ActionListener removeListener() {
        return this.setListener(null);
    }

    public JButton createExpandAllButton() {
        JButton button = new JButton(new AbstractAction(null, GUIResources.BUTTON_EXPAND_ALL_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpandablePanelGroup.this.expandAll();
            }
        });
        ExpandablePanel.makeButtonTransparent(button);
        return button;
    }

    public JButton createCollapseAllButton() {
        JButton button = new JButton(new AbstractAction(null, GUIResources.BUTTON_COLLAPSE_ALL_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpandablePanelGroup.this.collapseAll();
            }
        });
        ExpandablePanel.makeButtonTransparent(button);
        return button;
    }
}

