/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.runner.filesystem;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class FileUtils {
    public static boolean isAbsolutePath(String path) {
        return path.startsWith("/") || path.matches("^\\w:\\\\.*");
    }

    public static String joinPath(String ... splittedPath) {
        char separator = File.separatorChar;
        StringBuilder buffer = new StringBuilder();
        if (splittedPath == null) {
            throw new IllegalArgumentException("Internal error: null path not allowed");
        }
        for (int i = 0; i < splittedPath.length - 1; ++i) {
            buffer.append(splittedPath[i]);
            buffer.append(separator);
        }
        if (splittedPath.length > 0) {
            buffer.append(splittedPath[splittedPath.length - 1]);
        }
        return buffer.toString();
    }

    public static String[] splitPath(String filePath) {
        String separator = File.separatorChar == '\\' ? "\\\\" : File.separator;
        String[] path = filePath.split(separator);
        return path;
    }

    public static boolean close(Closeable closeable) {
        if (closeable == null) {
            return false;
        }
        try {
            closeable.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

