/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import tecgraf.javautils.gui.GUIResources;

public class MenuButton
extends JToggleButton {
    private static final int HORIZONTAL_GAP = 5;
    private static final int VERTICAL_GAP = 2;
    private PopupPosition popupPos;
    private JPopupMenu popup;
    private int arrowXoffset;
    private boolean alignRight;

    public MenuButton(String text, PopupPosition position) {
        this(text, position, false);
    }

    public MenuButton(String text, PopupPosition position, boolean alignRight) {
        super(text);
        this.alignRight = alignRight;
        this.init(position);
    }

    public MenuButton(Icon icon, PopupPosition position) {
        this(icon, position, false);
    }

    public MenuButton(Icon icon, PopupPosition position, boolean alignRight) {
        super(icon);
        this.alignRight = alignRight;
        this.init(position);
    }

    private void init(PopupPosition position) {
        this.popupPos = position;
        this.popup = new PopupMenu(this);
        this.setHorizontalTextPosition(10);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuButton.this.popup.show(MenuButton.this, 0, 0);
            }
        });
        this.arrowXoffset = this.popupPos.arrowWidth + 5 + 2;
        if (this.popupPos == PopupPosition.LEFT) {
            int leftMargin = this.getIconTextGap() + this.arrowXoffset;
            this.setMargin(new Insets(2, leftMargin, 2, 5));
        } else {
            int rightMargin = this.getIconTextGap() + this.arrowXoffset;
            this.setMargin(new Insets(2, 5, 2, rightMargin));
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int arrowXpos = this.popupPos == PopupPosition.LEFT ? 7 : this.getWidth() - this.arrowXoffset;
        int arrowYpos = this.getHeight() / 2 - this.popupPos.arrowHeight / 2;
        g.drawImage(this.popupPos.arrowImage, arrowXpos, arrowYpos, null);
    }

    public JMenuItem add(JMenuItem menuItem) {
        return this.popup.add(menuItem);
    }

    public JMenuItem add(Action action) {
        return this.popup.add(action);
    }

    public MenuButton addSeparator() {
        this.popup.addSeparator();
        return this;
    }

    public MenuButton setAlignRight(boolean alignRight) {
        this.alignRight = alignRight;
        return this;
    }

    private static class PopupMenu
    extends JPopupMenu {
        public PopupMenu(final MenuButton button) {
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    button.setSelected(false);
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    Point buttonPos = button.getLocationOnScreen();
                    Dimension size = PopupMenu.this.getPreferredSize();
                    int x = (int)buttonPos.getX();
                    int y = (int)buttonPos.getY();
                    int bw = button.getWidth();
                    int bh = button.getHeight();
                    switch (button.popupPos) {
                        case TOP: {
                            if (button.alignRight) {
                                x += bw - size.width;
                            }
                            y -= size.height;
                            break;
                        }
                        case LEFT: {
                            x -= size.width;
                            break;
                        }
                        case BOTTOM: {
                            if (button.alignRight) {
                                x += bw - size.width;
                            }
                            y += bh;
                            break;
                        }
                        case RIGHT: {
                            x += bw;
                            break;
                        }
                    }
                    PopupMenu.this.setLocation(x, y);
                }
            });
        }
    }

    public static enum PopupPosition {
        TOP(GUIResources.BUTTON_ARROW_UP_ICON),
        LEFT(GUIResources.BUTTON_ARROW_LEFT_ICON),
        BOTTOM(GUIResources.BUTTON_ARROW_DOWN_ICON),
        RIGHT(GUIResources.BUTTON_ARROW_RIGHT_ICON);

        Image arrowImage;
        int arrowHeight;
        int arrowWidth;

        private PopupPosition(ImageIcon icon) {
            this.arrowImage = icon.getImage();
            this.arrowWidth = this.arrowImage.getWidth(null);
            this.arrowHeight = this.arrowImage.getHeight(null);
        }
    }
}

